/**
 * TranslationNode
 * Created on Jul 19, 2007
 */
package pl.psnc.expres.broker.remote.tn;

import pl.psnc.expres.remote.broker.jobinfo.TranslationJobInfo;

/**
 * {@link ITranslationJob} interface - new translation job interface, used to
 * inform translation nodes about new experiment.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface ITranslationJob {

	/**
	 * Starts new translation job. This remote method is called by the VLBI
	 * Broker in order to contact Translation node to start new translation job.
	 * 
	 * @param jobInfo instance of {@link TranslationJobInfo} class, information
	 *        about translation job
	 */
	public void startTranslationJob(TranslationJobInfo jobInfo);

}
