/**
 * (c) 2009, Poznan Supercomputing and Networking Center (PSNC)
 * 
 * Implements {@link ICorrelationJob} interface to provide 
 * Mateusz Pabis (PSNC) - initial implementation
 */
package pl.psnc.expres.correlationNode;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.sdicons.json.mapper.MapperException;

import pl.psnc.expres.model.factory.CcfFactory;
import pl.psnc.expres.model.util.JsonReaderHelper;
import pl.psnc.expres.remote.broker.jobinfo.CorrelationJobInfo;
import pl.psnc.expres.remote.correlation.ICorrelationJob;
import pl.psnc.expres.remote.vex2ccf.model.CCFValue;
import pl.psnc.vlab.exception.ResourceNotFoundException;

/**
 * @author User
 *
 */
public class CorrelationJob implements ICorrelationJob {
	private static String PATH = "/opt/expres/data/";
	
	public void addObserver(int experimentId, String location) {
		try {
			BufferedWriter output = new BufferedWriter ( new FileWriter( PATH + "mateusz_test/file-" + experimentId) ); 
			output.write( Integer.toString( experimentId ) );
			output.write( "\n" );
			output.write( location );
			output.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void newChunkSetIsReady(CorrelationJobInfo jobInfo) {
		String expName = "exp-" + jobInfo.getExperimentId();
		String path = PATH + expName + "/";
		
		CCFValue model = null;
		try {
			model = CcfFactory.getCcfModel( new BufferedInputStream ( new FileInputStream( path + expName + ".ccf" ) ) );
		} catch (ResourceNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if ( model != null ){
			Map<String, String> dataSources = jobInfo.getDataSources();
			Map<String, List<String>> map = new HashMap<String, List<String>>( dataSources.size() );
			for (String key : dataSources.keySet() ) {
				List<String> list = new ArrayList<String>(1);
				list.add( dataSources.get( key ));
				map.put( key, list );
			}
			model.setData_sources( map );
			model.setStop( jobInfo.getEndTime() );
			model.setStart( jobInfo.getStartTime() );
			model.setOutput_file( "file://" + path + expName + ".cor" );
			
			this.toFile(model, path + expName + ".ctrl");
			
		}
		this.generateScripts(jobInfo);

		// and run the script
//		this.runScript( path + "submit.sh" );
		
	}

	private int runScript( String location ) {
		int exitVal = -1;
        try {
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec( location );

//            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
//
//            String line=null;
//
//            while((line=input.readLine()) != null) {
//                System.out.println(line);
//            }
            exitVal = pr.waitFor();
        } catch(Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        return exitVal;
	}

	public void newCorrelationJob(int experimentId, byte[] ccf, byte[] vex) {
		String expName = "exp-" + experimentId;
		String path = PATH + expName + "/";
		File dataDir = new File( path );
		dataDir.mkdir();
		
		// Save control file
		try {
			BufferedWriter output = new BufferedWriter ( new FileWriter( path + expName + ".ccf" ) ); 
			output.write( new String( ccf ) );
			output.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		}		
		
		// Save VEX file
		try {
			BufferedWriter output = new BufferedWriter ( new FileWriter( path + expName + ".vix" ) ); 
			output.write( new String( vex ) );
			output.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		

	}
	private void toFile( CCFValue model , String location ) {
		try {
			BufferedWriter output = new BufferedWriter ( new FileWriter( location ) );
			output.write( JsonReaderHelper.jsonToString( model ) );
			output.close();
			
		} catch (MapperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	private void generateScripts( CorrelationJobInfo jobInfo ) {
		String expName = "exp-" + jobInfo.getExperimentId();
		String path = PATH + expName + "/";
		
		try {
		// submit
			BufferedWriter output = new BufferedWriter ( new FileWriter( path + "submit.sh" ) );
			output.write( "#!/bin/bash\n" );
			output.write( "/usr/bin/qsub -q expres -W x=FLAGS:ADVRES:kettenis.0 mpi_script.sh\n" );
			output.close();
			File script = new File( path + "submit.sh" );
			script.setExecutable( true );
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		try {
			// MPI Script
			BufferedWriter output = new BufferedWriter(new FileWriter(path + "mpi_script.sh"));
			
			
			output.write( "#!/bin/bash\n");
//			#PBS -l nodes=2:ppn=8:ib
//			#PBS -l mem=1024mb

//			#export MPI_VERSION="openmpi_gcc-1.2.4"
//			#export MPI_VERSION="mvapich2_gcc-0.9.8"
//			#export MPI_VERSION="mvapich_gcc-0.9.9"
			output.write( "export MPI_VERSION=\"mvapich_gcc\"\nsource /etc/mpi.sh\necho `which mpiexec`\necho `which mpirun`\n");
			output.write( "MACHINEFILENAME=$PBS_O_WORKDIR/$PBS_JOBID.machinefile\n" );
			output.write( "cd $PBS_O_WORKDIR");
			output.write( "cp $PBS_NODEFILE $MACHINEFILENAME");

			output.write( "export PATH=$PATH:/opt/expres/soft/sfxc/bin");
			output.write( "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/lib64:/usr/lib64:/opt/expres/soft/sfxc/lib");
			output.write( "export CALC_DIR=/opt/expres/soft/sfxc/share");

			output.write( "mpiexec -allstdin -n 14 -comm ib /opt/expres/soft/sfxc/bin/sfxc \\");
			output.write( path + expName + ".ctrl \\");
			output.write( path + expName + ".vix 2>&1 > sfxc_script.out");

			output.write( "rm -f $MACHINEFILENAME");			output.close();
			File script = new File(path + "submit.sh");
			script.setExecutable(true);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
