package pl.psnc.expres.model.factory;

import static org.junit.Assert.fail;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;

import pl.psnc.expres.model.experiment.VlbiExperiment;
import pl.psnc.expres.model.util.JsonReaderHelper;

/**
 * {@link VlbiExperimentFactoryTest} class
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class VlbiExperimentFactoryTest {

	/** Stores instance of field: log */
	private Log log = LogFactory.getLog(VlbiExperimentFactoryTest.class);

	/** Stores instance of field: vlbiExperiment */
	String vlbiExperiment;

	/**
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {

	}

	/**
	 * Test method for
	 * {@link pl.psnc.expres.wfm.remote.vlbi.experiment.SubmitVlbiExperimentStub#newVlbiExperiment(pl.psnc.expres.wfm.remote.vlbi.experiment.SubmitVlbiExperimentStub.NewVlbiExperiment)}.
	 */
	@Test
	public void testGetInstance() {
		try {
			VlbiExperiment instance = VlbiExperimentFactory
					.getInstance("build/model/vlbiExperiment1.json");

			String jsonToString = JsonReaderHelper.jsonToString(instance);
			log.debug(jsonToString);

		} catch (Exception e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
	}

}
