/**
 * CCFValue.java
 * Created on Oct 29, 2007, 3:14:13 PM
 */
package pl.psnc.expres.remote.vex2ccf.model;

import java.util.List;
import java.util.Map;

/**
 * {@link CCFValue} class - correlator control file value object - describes
 * properties of the CCF.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class CCFValue {

	/**
	 * Defines whether all cross polarisation pairs are computed or not.
	 */
	boolean cross_polarize;

	/**
	 * An associative array containing the data sources for the correlation.
	 * Each field maps a station to an array of data sources. The data sources
	 * are subsequently read during the correlation. The data sources can be
	 * specified as a file "file://<path>/<filename>", a tcp connection (the
	 * host and port of the receiving side) "tcp://<host>:<port>" "udp://<host>:<port>"
	 */
	Map<String, List<String>> data_sources;

	/**
	 * [optional] The directory containing the delay tables. The delay tables
	 * are pre-generated so that they can be used for multiple experiments.
	 */
	String delay_directory;

	/** Name of the experiment */
	private String exper_name;

	/**
	 * The integration time in seconds. This should be a value in the range
	 * [0.25, 0.5, 1.0, 2.0, 4.0]
	 */
	double integr_time;

	/**
	 * The amount of log-messages the correlator should produce. - 0 no output -
	 * 1 some output - 2 debugging
	 * 
	 */
	byte message_level;

	/**
	 * The number of frequency channels. This should be a power of two,
	 * generally between 32 and 4096.
	 * 
	 */
	int number_channels;

	/**
	 * The file in which the output of the correlator is stored.
	 */
	String output_file;

	/**
	 * [optional] All baselines are correlated if the reference station is not
	 * specified. If the reference_station is specified, it is one of the
	 * stations specified in "stations", which is used as a reference station.
	 */
	private String reference_station;

	/**
	 * An associative array of the position of the telescopes. These positions
	 * are taken from the vex-file
	 */
	Map<String, List<String>> site_position;

	/**
	 * The start time of the correlation job. The format is the same as in the
	 * vex-file.
	 */
	private String start;

	/**
	 * A list of the telescopes from which the data is correlated This should be
	 * a subset of the telescopes described in the vex-file.
	 */
	private List<String> stations;

	/**
	 * The stop time of the correlation job. The format is the same as in the
	 * vex-file.
	 */
	private String stop;

	/**
	 * An array of frequencies at which the telescopes observe. Each element
	 * contains the fields frequency, bandwidth, sideband and polarisation.
	 */
	List<CCFFrequency> frequencies;

	// ----------------------------------------------------------------------------------
	// ---- Setters/Getters

	/**
	 * Get value of field: cross_polarize
	 * 
	 * @return the cross_polarize
	 */
	public boolean isCross_polarize() {
		return cross_polarize;
	}

	/**
	 * Set value of field: cross_polarize
	 * 
	 * @param cross_polarize the cross_polarize to set
	 */
	public void setCross_polarize(boolean cross_polarize) {
		this.cross_polarize = cross_polarize;
	}

	/**
	 * Get value of field: data_sources
	 * 
	 * @return the data_sources
	 */
	public Map<String, List<String>> getData_sources() {
		return data_sources;
	}

	/**
	 * Set value of field: data_sources
	 * 
	 * @param data_sources the data_sources to set
	 */
	public void setData_sources(Map<String, List<String>> data_sources) {
		this.data_sources = data_sources;
	}

	/**
	 * Get value of field: delay_directory
	 * 
	 * @return the delay_directory
	 */
	public String getDelay_directory() {
		return delay_directory;
	}

	/**
	 * Set value of field: delay_directory
	 * 
	 * @param delay_directory the delay_directory to set
	 */
	public void setDelay_directory(String delay_directory) {
		this.delay_directory = delay_directory;
	}

	/**
	 * Get value of field: exper_name
	 * 
	 * @return the exper_name
	 */
	public String getExper_name() {
		return exper_name;
	}

	/**
	 * Set value of field: exper_name
	 * 
	 * @param exper_name the exper_name to set
	 */
	public void setExper_name(String exper_name) {
		this.exper_name = exper_name;
	}

	/**
	 * Get value of field: integr_time
	 * 
	 * @return the integr_time
	 */
	public double getIntegr_time() {
		return integr_time;
	}

	/**
	 * Set value of field: integr_time
	 * 
	 * @param integr_time the integr_time to set
	 */
	public void setIntegr_time(double integr_time) {
		this.integr_time = integr_time;
	}

	/**
	 * Get value of field: message_level
	 * 
	 * @return the message_level
	 */
	public byte getMessage_level() {
		return message_level;
	}

	/**
	 * Set value of field: message_level
	 * 
	 * @param message_level the message_level to set
	 */
	public void setMessage_level(byte message_level) {
		this.message_level = message_level;
	}

	/**
	 * Get value of field: number_channels
	 * 
	 * @return the number_channels
	 */
	public int getNumber_channels() {
		return number_channels;
	}

	/**
	 * Set value of field: number_channels
	 * 
	 * @param number_channels the number_channels to set
	 */
	public void setNumber_channels(int number_channels) {
		this.number_channels = number_channels;
	}

	/**
	 * Get value of field: output_file
	 * 
	 * @return the output_file
	 */
	public String getOutput_file() {
		return output_file;
	}

	/**
	 * Set value of field: output_file
	 * 
	 * @param output_file the output_file to set
	 */
	public void setOutput_file(String output_file) {
		this.output_file = output_file;
	}

	/**
	 * Get value of field: reference_station
	 * 
	 * @return the reference_station
	 */
	public String getReference_station() {
		return reference_station;
	}

	/**
	 * Set value of field: reference_station
	 * 
	 * @param reference_station the reference_station to set
	 */
	public void setReference_station(String reference_station) {
		this.reference_station = reference_station;
	}

	/**
	 * Get value of field: site_position
	 * 
	 * @return the site_position
	 */
	public Map<String, List<String>> getSite_position() {
		return site_position;
	}

	/**
	 * Set value of field: site_position
	 * 
	 * @param site_position the site_position to set
	 */
	public void setSite_position(Map<String, List<String>> site_position) {
		this.site_position = site_position;
	}

	/**
	 * Get value of field: start
	 * 
	 * @return the start
	 */
	public String getStart() {
		return start;
	}

	/**
	 * Set value of field: start
	 * 
	 * @param start the start to set
	 */
	public void setStart(String start) {
		this.start = start;
	}

	/**
	 * Get value of field: stations
	 * 
	 * @return the stations
	 */
	public List<String> getStations() {
		return stations;
	}

	/**
	 * Set value of field: stations
	 * 
	 * @param stations the stations to set
	 */
	public void setStations(List<String> stations) {
		this.stations = stations;
	}

	/**
	 * Get value of field: stop
	 * 
	 * @return the stop
	 */
	public String getStop() {
		return stop;
	}

	/**
	 * Set value of field: stop
	 * 
	 * @param stop the stop to set
	 */
	public void setStop(String stop) {
		this.stop = stop;
	}

	/**
	 * Get value of field: frequencies
	 * 
	 * @return the frequencies
	 */
	public List<CCFFrequency> getFrequencies() {
		return frequencies;
	}

	/**
	 * Set value of field: frequencies
	 * 
	 * @param frequencies the frequencies to set
	 */
	public void setFrequencies(List<CCFFrequency> frequencies) {
		this.frequencies = frequencies;
	}

}