/**
 * Created on Sep 3, 2008
 */
package pl.psnc.expres.remote.network;

import java.util.List;

import pl.psnc.expres.remote.network.value.NetworkMetric;

/**
 * {@link INetworkMonitor} interface - defines an interface between Vlbi Broker
 * and EXPReS Network Monitor (ENM). This interface is used to request network
 * metrics and find best connection match-up between translation node (TN) and
 * file servers (FS).
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface INetworkMonitor {

	/**
	 * Creates a new network metric order. This order will be processed by the
	 * EXPReS Network Module (ENM).
	 * 
	 * @param translationNodes list of translation nodes identifiers
	 * @param fileServers list of file servers identifiers
	 * @return metric order identifier
	 */
	public int orderNetworkMetric(int translationNodes[], int fileServers[]);

	/**
	 * Adds new network metric observer. Whenever new network order with the
	 * given order identifier is ready, the given observer is notified.
	 * 
	 * @param networkOrderId identifier of the network metric
	 * @param location location of observer
	 */
	public void addObserver(int networkOrderId, String location);

	/**
	 * Get network metric by the specified network order identifier. If the
	 * network metrics is not ready than <code>NULL</code> is returned.
	 * 
	 * @param networkOrderId identifier of the network metrics
	 * @return network metric or <code>NULL</code> if network metric is not
	 *         ready yet.
	 */
	public List<NetworkMetric> getNetworkMetric(int networkOrderId);

}