/**
 * Created on Sep 3, 2008
 */
package pl.psnc.expres.remote.network;

import java.util.List;

import pl.psnc.expres.remote.network.value.NetworkMetric;
import pl.psnc.expres.remote.network.value.NetworkMetricStatus;

/**
 * {@link INetworkMetricNotification} interface - used by the EXPReS Network
 * Module (ENM) to notify that network metric with the specified network
 * identifier has been completed.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface INetworkMetricNotification {

	/**
	 * The update method is called by the ENM module, when requested metric has
	 * been successfully created.
	 * 
	 * @param networkOrderId identifier of the network metrics
	 * @param networkMetric requested network metrics from best to worst
	 *        scenario
	 */
	public void update(int networkOrderId, List<NetworkMetric> networkMetric);

	/**
	 * The update method is called by the ENM module to provide current status
	 * of network metric preparation.
	 * 
	 * @param networkOrderId identifier of the network metrics
	 * @param networkMetricStatus
	 */
	public void update(int networkOrderId, NetworkMetricStatus networkMetricStatus);

}
