/**
 * Created on Aug 27, 2008
 */
package pl.psnc.expres.remote.helper;

import javax.activation.DataHandler;

import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.model.experiment.VlbiExperiment;
import pl.psnc.expres.model.util.JsonReaderHelper;
import pl.psnc.expres.remote.broker.xsd.RemoteVlbiExperiment;
import pl.psnc.expres.remote.broker.xsd.StartVlbiExperiment;

import com.sdicons.json.mapper.MapperException;

/**
 * {@link RemoteHelper} class - remote helper class for axis stubs
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class RemoteHelper {

	/** Stores instance of field: log */
	private static Log log = LogFactory.getLog(RemoteHelper.class);

	/**
	 * Creates a new instance of {@link NewVlbiExperiment} based on given
	 * {@link VlbiExperiment}
	 * 
	 * @param vlbiExperiment instance of {@link VlbiExperiment}
	 * @return new instance of {@link NewVlbiExperiment}
	 * @throws MapperException
	 */
	public static StartVlbiExperiment getNewVlbiExperiment(VlbiExperiment vlbiExperiment)
			throws MapperException {
		if (vlbiExperiment == null) {
			log.info("VlbiExperiment is NULL");
			return null;
		}

		StartVlbiExperiment newVlbiExperiment = new StartVlbiExperiment();

		RemoteVlbiExperiment rVlbiExp = new RemoteVlbiExperiment();

		// vlbi experimnt
		String value = JsonReaderHelper.jsonToString(vlbiExperiment);
		if (value != null) {
			ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(value.getBytes());
			rVlbiExp.setVlbiExperiment(new DataHandler(byteArrayDataSource));
		}

		// TODO add graph connections
		// connections
		value = JsonReaderHelper.jsonToString(vlbiExperiment.getConnections());
		if (value != null) {
			ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(value.getBytes());
			rVlbiExp.setConnections(new DataHandler(byteArrayDataSource));
		}

		// vex file
		ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(vlbiExperiment
				.getVexFile());
		rVlbiExp.setVex(new DataHandler(byteArrayDataSource));

		newVlbiExperiment.setParam0(rVlbiExp);
		return newVlbiExperiment;
	}
}
