/**
 * Created on 23 Jan 2009
 */
package pl.psnc.expres.remote.correlation;

import pl.psnc.expres.remote.broker.jobinfo.CorrelationJobInfo;

/**
 * {@link ICorrelationJob} interface - remote interface between Vlbi Broker and
 * Job Submitter
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface ICorrelationJob {

	/**
	 * Informs that new correlation job is about be started. This means that
	 * many correlation jobs will be submitted for correlation.
	 * 
	 * @param experimentId experiment identifier
	 * @param ccf correlator control file
	 * @param vex vex file
	 */
	public void newCorrelationJob(int experimentId, byte ccf[], byte vex[]);

	/**
	 * Informs that new chunk set is ready for the correlation
	 * 
	 * @param correlationJobInfo instance of {@link CorrelationJobInfo}, stores
	 *        information about chunks to be correlated
	 */
	public void newChunkSetIsReady(CorrelationJobInfo correlationJobInfo);

	/**
	 * Adds new correlation job observer. Whenever new data set is correlated,
	 * the given observer is notified.
	 * 
	 * @param experimentId identifier of the vlbi experiment
	 * @param location location of an observer
	 */
	public void addObserver(int experimentId, String location);

}
