/**
 * VlbiExperiment.java
 * Created on Nov 22, 2007, 1:52:41 PM
 */
package pl.psnc.expres.remote.broker;

/**
 * {@link RemoteVlbiExperiment} class - used to describe VLBI experiment
 * workflow. It contains experiment details like name, description and list of
 * resources and their connections, vex file, ccf file
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class RemoteVlbiExperiment {

	/** Holds content of */
	private byte vlbiExperiment[];

	/** Stores resource's connections */
	private byte connections[];

	/** Holds experiment VEX file */
	private byte vex[];

	// ----------------------------------------------------------------------------------
	// ----- Getters/Setters

	/**
	 * Get value of field: connections
	 * 
	 * @return the connections
	 */
	public byte[] getConnections() {
		return connections;
	}

	/**
	 * Set value of field: connections
	 * 
	 * @param connections the connections to set
	 */
	public void setConnections(byte[] connections) {
		this.connections = connections;
	}

	/**
	 * Get value of field: vex
	 * 
	 * @return the vex
	 */
	public byte[] getVex() {
		return vex;
	}

	/**
	 * Set value of field: vex
	 * 
	 * @param vex the vex to set
	 */
	public void setVex(byte[] vex) {
		this.vex = vex;
	}

	/**
	 * Get value of field: vlbiExperiment
	 * 
	 * @return the vlbiExperiment
	 */
	public byte[] getVlbiExperiment() {
		return vlbiExperiment;
	}

	/**
	 * Set value of field: vlbiExperiment
	 * 
	 * @param vlbiExperiment the vlbiExperiment to set
	 */
	public void setVlbiExperiment(byte[] vlbiExperiment) {
		this.vlbiExperiment = vlbiExperiment;
	}

}
