/**
 * ResourceValue.java
 * Created on Nov 12, 2007, 2:14:15 PM
 */
package pl.psnc.expres.model.resource;

import pl.psnc.graph.model.type.AbstractResourceValue;

/**
 * {@link ResourceValue} class - resource value description (value object).
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class ResourceValue extends AbstractResourceValue implements Cloneable {

	/** Resource identifier */
	private int id;

	/** Resource abbreviation */
	private String abbreviation;

	/** Resource type identifier */
	private int typeId;

	/** Resource name */
	private String name;

	/** Resource description */
	private String description;

	/** Resource hostname */
	private String hostname;

	/** Resource service location */
	private String serviceLocation;

	/** Location of grid ftp server */
	private String gridFTPLocation;

	/** Resource measurement service location - used by network metrics module */
	private String measurementServiceLocation;

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return new StringBuffer().append("Id=").append(id).append("Type Id=").append(typeId)
				.append("Name=").append(name).append("Description=").append(description).toString();
	}

	// -----------------------------------------------------------------------------------
	// ---- Setters/Getters

	/**
	 * Get value of the property: abbreviation
	 * 
	 * @return the abbreviation
	 */
	public String getAbbreviation() {
		return abbreviation;
	}

	/**
	 * Set value of the property: abbreviation
	 * 
	 * @param abbreviation the abbreviation to set
	 */
	public void setAbbreviation(String abbreviation) {
		this.abbreviation = abbreviation;
	}

	/**
	 * Get value of field: id
	 * 
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * Set value of field: id
	 * 
	 * @param id the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Get value of field: typeId
	 * 
	 * @return the typeId
	 */
	public int getTypeId() {
		return typeId;
	}

	/**
	 * Set value of field: typeId
	 * 
	 * @param typeId the typeId to set
	 */
	public void setTypeId(int typeId) {
		this.typeId = typeId;
	}

	/**
	 * Get value of field: name
	 * 
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set value of field: name
	 * 
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Get value of field: description
	 * 
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Set value of field: description
	 * 
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Get value of field: hostname
	 * 
	 * @return the hostname
	 */
	public String getHostname() {
		return hostname;
	}

	/**
	 * Set value of field: hostname
	 * 
	 * @param hostname the hostname to set
	 */
	public void setHostname(String hostname) {
		this.hostname = hostname;
	}

	/**
	 * Get value of field: serviceLocation
	 * 
	 * @return the serviceLocation
	 */
	public String getServiceLocation() {
		return serviceLocation;
	}

	/**
	 * Set value of field: serviceLocation
	 * 
	 * @param serviceLocation the serviceLocation to set
	 */
	public void setServiceLocation(String serviceLocation) {
		this.serviceLocation = serviceLocation;
	}

	/**
	 * Get value of field: measurementServiceLocation
	 * 
	 * @return the measurementServiceLocation
	 */
	public String getMeasurementServiceLocation() {
		return measurementServiceLocation;
	}

	/**
	 * Set value of field: measurementServiceLocation
	 * 
	 * @param measurementServiceLocation the measurementServiceLocation to set
	 */
	public void setMeasurementServiceLocation(String measurementServiceLocation) {
		this.measurementServiceLocation = measurementServiceLocation;
	}

	/**
	 * Get value of field: gridFTPLocation
	 * 
	 * @return the gridFTPLocation
	 */
	public String getGridFTPLocation() {
		return gridFTPLocation;
	}

	/**
	 * Set value of field: gridFTPLocation
	 * 
	 * @param gridFTPLocation the gridFTPLocation to set
	 */
	public void setGridFTPLocation(String gridFTPLocation) {
		this.gridFTPLocation = gridFTPLocation;
	}

}
