/**
 * Created on Aug 11, 2008
 */
package pl.psnc.expres.model.factory.helper;

import javax.activation.DataHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.expres.model.experiment.VlbiExperiment;
import pl.psnc.expres.remote.broker.xsd.RemoteVlbiExperiment;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.remote.util.RemoteHelper;

/**
 * {@link VlabiExperimentHelper} class - vlbi experiment helper class.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class VlabiExperimentHelper {

	/** Stores instance of field: log */
	private static Log log = LogFactory.getLog(VlabiExperimentHelper.class);

	/**
	 * Converts remote vlbi experiment (instance of {@link RemoteVlbiExperiment})
	 * to vlbi experiment (instance of {@link VlbiExperiment})
	 * 
	 * @param vlbiExp vlabi experiment
	 * @param remoteVlbiExp remote vlbi experiment (instance of
	 *        {@link RemoteVlbiExperiment})
	 * @return new instance of vlbi experiment ( {@link VlbiExperiment} )
	 */
	public static VlbiExperiment convert(VlbiExperiment vlbiExp, RemoteVlbiExperiment remoteVlbiExp)
			throws ResourceNotFoundException {
		log.debug("<getVlbiExperiment>");
		if (remoteVlbiExp == null) {
			log.debug("</getVlbiExperiment: NULL>");
			return null;
		}
		try {

			// vex
			DataHandler dataHandler = remoteVlbiExp.getVex();
			vlbiExp.setVexFile(RemoteHelper.getBytes(dataHandler));

			// connections
			dataHandler = remoteVlbiExp.getConnections();
			vlbiExp.setConnections(RemoteHelper.getBytes(dataHandler));

			log.debug("</getVlbiExperiment>");
			return vlbiExp;
		} catch (Exception e) {
			log.debug("</getVlbiExperiment: ERROR>");
			throw new ResourceNotFoundException(e.getLocalizedMessage(), e);
		}
	}

}
