/*
 * DefaultPortView.java
 *
 * Created on 8 listopad 2006, 16:13
 */

package pl.psnc.graph.view;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.jgraph.JGraph;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.PortView;

import pl.psnc.graph.renderer.CustomPortRenderer;

/**
 * {@link DefaultPortView} class - default implementation of port view.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class DefaultPortView extends PortView {

	/** Stores instance of field: serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** Holds instance of a renderer for this class */
	private static CellViewRenderer renderer = new CustomPortRenderer();

	/** Stores instance of field: visible */
	private boolean visible;

	/**
	 * Creates a new instance of DefaultPortView
	 * 
	 * @param userObject user object
	 */
	public DefaultPortView(Object userObject) {
		super(userObject);
		SIZE = (int) ((CustomPortRenderer) getRenderer()).getIconSize().getWidth();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.PortView#getRenderer()
	 */
	public CellViewRenderer getRenderer() {
		return renderer;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.PortView#getBounds()
	 */
	public Rectangle2D getBounds() {
		Point2D loc = getLocation();
		double x = 0;
		double y = 0;
		if (loc != null) {
			x = loc.getX();
			y = loc.getY();
		}
		Rectangle2D bounds = new Rectangle2D.Double(x, y, 0, 0);
		bounds.setFrame(bounds.getX() - SIZE / 2, bounds.getY() - SIZE / 2, SIZE, SIZE);
		return bounds;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.AbstractCellView#getRendererComponent(org.jgraph.JGraph,
	 *      boolean, boolean, boolean)
	 */
	public Component getRendererComponent(JGraph graph, boolean selected, boolean focus,
			boolean preview) {
		// log.debug("Port VIEW -> foces="+focus+" sel="+selected +"
		// prew="+preview);
		return super.getRendererComponent(graph, selected, focus, preview);
	}

	/**
	 * Getter for property visible.
	 * 
	 * @return Value of property visible.
	 */
	public boolean isVisible() {
		return this.visible;
	}

	/**
	 * Setter for property visible.
	 * 
	 * @param visible New value of property visible.
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}

}
