/*
 * ImageKeys.java
 *
 * Created on 14 maj 2004, 11:08
 */

package pl.psnc.graph.util.image;

/**
 * {@link ImageKeys} class - contains all the image names which are used by the
 * jGraph component.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class ImageKeys {

	/** The root directory of the images */
	public static String ROOT = "images";

	// --------------------------------------------------------------------------
	// ----------- The JGraph Icons

	/** Graph cell port image */
	public static final String PORT_IMAGE = ROOT + "/node/red_dot.gif";

	/** Copy */
	public static String COPY = ROOT + "/edit/copy_edit.gif";
	public static String COPY_DISABLED = ROOT + "/edit/copy_edit_disabled.gif";

	/** Paste icon */
	public static String PASTE = ROOT + "/edit/paste_edit.gif";
	public static String PASTE_DISABLED = ROOT + "/edit/paste_edit_disabled.gif";

	/** Delete icon */
	public static String DELETE = ROOT + "/edit/delete_edit.gif";
	public static String DELETE_DISABLED = ROOT + "/edit/delete_edit_disabled.gif";

	/** Actual size icon */
	public static String ACTUAL_SIZE = ROOT + "/edit/16x16_Lupa_active.gif";
	public static String ACTUAL_SIZE_DISABLED = ROOT + "/edit/menu/16x16_Lupa_pasive.gif";

	/** Zoom out icon */
	public static String ZOOM_OUT = ROOT + "/edit/16x16_LupaMinus_active.gif";
	public static String ZOOM_OUT_DISABLED = ROOT + "/edit/16x16_LupaMinus_pasive.gif";

	/** Zoom in icon */
	public static String ZOOM_IN = ROOT + "/edit/16x16_LupaPlus_active.gif";
	public static String ZOOM_IN_DISABLED = ROOT + "/edit/16x16_LupaPlus_pasive.gif";

	/** Undo icon */
	public static String UNDO = ROOT + "/edit/undo.gif";
	public static String UNDO_DISABLED = ROOT + "/edit/undo_disabled.gif";

	/** Redo icon */
	public static String REDO = ROOT + "/edit/redo.gif";
	public static String REDO_DISABLED = ROOT + "/edit/redo_disabled.gif";

}
