/*
 * CustomGraphUI.java
 *
 * Created on 1 kwiecie� 2004, 16:47
 */

package pl.psnc.graph.ui;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;

import org.jgraph.plaf.basic.BasicGraphUI;

import pl.psnc.graph.model.CustomGraph;
import pl.psnc.vlab.util.swing.gui.ColorKeys;

/**
 * {@link CustomGraphUI} class - overridden class BasicGrapUI - it adds method
 * for background image display
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
// TODO -> this class should be generalized
public class CustomGraphUI extends BasicGraphUI {

	/** Default Serial uid */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new instance of custom graph ui
	 */
	public CustomGraphUI() {
	}

	/**
	 * Get current custom graph
	 * 
	 * @return current custom graph
	 */
	public CustomGraph getScenarioGraph() {
		return (CustomGraph) graph;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.plaf.basic.BasicGraphUI#paintBackground(java.awt.Graphics)
	 */
	protected void paintBackground(java.awt.Graphics g) {
		Dimension pageBounds = graph.getSize();
		Graphics2D g2d = (Graphics2D) g;
		Paint storedPaint = g2d.getPaint();
		g2d.setPaint(new GradientPaint(0, 0, ColorKeys.GRADIENT_LIGHT_GRAY_AND_WHITE[0],
				pageBounds.width, 0, ColorKeys.GRADIENT_LIGHT_GRAY_AND_WHITE[1]));
		g2d.fillRect(0, 0, pageBounds.width, pageBounds.height);
		g2d.setPaint(storedPaint);
	}

}
