/*
 * RendererFactory.java
 *
 * Created on 23 kwiecien 2004, 16:32
 */

package pl.psnc.graph.renderer;

import java.util.HashMap;
import java.util.Map;

import javax.swing.ImageIcon;

import pl.psnc.vlab.util.image.ImageFactory;

/**
 * {@link RendererFactory} class - abstract class is used to get instances of
 * the image vertex renderers for the application.
 * 
 * @author Dominik Stoklosa
 * @email osa@man.poznan.pl
 */
public abstract class RendererFactory {

	/** The renderers map */
	private static Map<String, ImageVertexRenderer> rendererList = new HashMap<String, ImageVertexRenderer>();

	/**
	 * Get the ImageVertexRenderer for the given vertex type
	 * 
	 * @param iconName name of the icon
	 * @return new instance of {@link ImageVertexRenderer}
	 */
	public static ImageVertexRenderer getRenderer(String iconName) {
		ImageVertexRenderer renderer = rendererList.get(iconName);
		if (renderer == null) {
			ImageIcon imageIcon = ImageFactory.getImageBean(iconName).getImage();
			if (imageIcon == null) {
				return null;
			}
			renderer = new ImageVertexRenderer(imageIcon);
			rendererList.put(iconName, renderer);
		}
		return renderer;
	}

}
