package pl.psnc.graph.model.value;

import java.io.Serializable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.graph.model.type.AbstractResourceType;
import pl.psnc.graph.model.type.AbstractResourceValue;

/**
 * {@link GraphCellObject} class - stores properties of each graph node
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class GraphCellObject implements Serializable {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	@SuppressWarnings("unused")
	private static Log log = LogFactory.getLog(GraphCellObject.class);

	/** Holds value of property type. */
	private AbstractResourceType type;

	/** Stores resource properties */
	private AbstractResourceValue resource;

	/**
	 * Creates a new instance of Graph Cell Object
	 * 
	 * @param type resource type
	 */
	public GraphCellObject(AbstractResourceType type, AbstractResourceValue resourceValue) {
		this.type = type;
		this.resource = resourceValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return resource.getName();
	}

	// =================================================================
	// === Setters/Getters

	/**
	 * Get value of the property: type
	 * 
	 * @return the type
	 */
	public AbstractResourceType getType() {
		return type;
	}

	/**
	 * Set value of the property: type
	 * 
	 * @param type the type to set
	 */
	public void setType(AbstractResourceType type) {
		this.type = type;
	}

	/**
	 * Get value of the property: resource
	 * 
	 * @return the resource
	 */
	public AbstractResourceValue getResource() {
		return resource;
	}

	/**
	 * Set value of the property: resource
	 * 
	 * @param resource the resource to set
	 */
	public void setResource(AbstractResourceValue resource) {
		this.resource = resource;
	}

}
