/*
 * CustomGraphModelListener.java
 *
 * Created on 23 lipiec 2004, 16:56
 */

package pl.psnc.graph.model.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.event.GraphModelListener;

import pl.psnc.graph.model.CustomGraph;

/**
 * {@link CustomGraphModelListener} class - model graph listener is informed
 * when the cells are inserted, removed or when the label, source, target,
 * parent or children of an object have changed.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CustomGraphModelListener implements GraphModelListener {

	/** Instance of logger */
	private Log log = LogFactory.getLog(CustomGraphModelListener.class);

	/** Stores an instance of current graph */
	private CustomGraph graph = null;

	/**
	 * Creates an instance of Scenario Graph Model Listener
	 * 
	 * @param graph instance of {@link CustomGraph}
	 */
	public CustomGraphModelListener(CustomGraph graph) {
		this.graph = graph;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.event.GraphModelListener#graphChanged(org.jgraph.event.GraphModelEvent)
	 */
	public void graphChanged(org.jgraph.event.GraphModelEvent graphModelEvent) {
		log.debug("<graphChanged>");
		log.debug("</graphChanged>");

	}

	// ----------------------------------------------------------------------------------
	// ---- Setters / Getters

	/**
	 * Get value of field: graph
	 * 
	 * @return the graph
	 */
	public CustomGraph getGraph() {
		return graph;
	}

	/**
	 * Set value of field: graph
	 * 
	 * @param graph the graph to set
	 */
	public void setGraph(CustomGraph graph) {
		this.graph = graph;
	}

}
