package pl.psnc.graph.io;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

/**
 * {@link GraphFileFilter} class - file filter which is used with
 * {@link JFileChooser} dialog.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class GraphFileFilter extends FileFilter {

	/** Extension of accepted files. */
	protected String extension;

	/** Description of accepted files. */
	protected String description;

	/**
	 * Constructs a new filter for the specified extension and description.
	 * 
	 * @param extension the extension to accept files with.
	 * @param description the description of the file format.
	 */
	public GraphFileFilter(String extension, String description) {
		this.extension = extension.toLowerCase();
		this.description = description;
	}

	/**
	 * Returns true if <code>file</code> is a directory or ends with
	 * {@link #extension}.
	 * 
	 * @param file The file to be checked.
	 * @return Returns true if the file is accepted.
	 */
	public boolean accept(File file) {
		return file.isDirectory() || file.getName().toLowerCase().endsWith(extension);
	}

	// ----------------------------------------------------------------------------------------
	// ---- Setters / Getters

	/**
	 * Get value of the property: extension
	 * 
	 * @return the extension
	 */
	public String getExtension() {
		return extension;
	}

	/**
	 * Get value of the property: description
	 * 
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

}
