/*
 * GraphBundleFactory.java
 *
 * Created on March 16, 2008, 3:28 PM
 */

package pl.psnc.graph.i18n;

import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.i18n.ResourceBundleManager;

/**
 * {@link GraphBundleFactory} class - factory class for i18n resources retrieval
 * for jGraph component.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public abstract class GraphBundleFactory {

	/** The resource property file */
	private static final String BUNDLE = "bundle/jgraph";

	/**
	 * Stores the key with message set when the specified key value cannot be
	 * found
	 */
	private static final String KEY_NOT_FOUND = "message.key.not.found";

	/** Instance of MessageBundle */
	private static ResourceBundleManager bundleInstance;

	/**
	 * Get the value for the given key for corresponding resource bundle
	 * 
	 * @param key key for the desired string
	 * @return value of the given key
	 * @throws ResourceNotFoundException thrown when bundle manager
	 *             initialization fails.
	 */
	public static String getValue(String key) throws ResourceNotFoundException {
		if (bundleInstance == null) {
			bundleInstance = new ResourceBundleManager(BUNDLE, null, KEY_NOT_FOUND);
		}
		return bundleInstance.getValue(key);
	}
}
