/*
 * Created by JFormDesigner on Tue Apr 29 14:06:54 CEST 2008
 */

package pl.psnc.graph.gui.popup;

import java.util.ResourceBundle;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import pl.psnc.graph.action.factory.GraphActionType;
import pl.psnc.vlab.exception.ResourceNotFoundException;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;
import pl.psnc.vlab.util.gui.action.helper.ActionHelper;

/**
 * {@link JCustomGraphPopup} class - default graph popup menu
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class JCustomGraphPopup extends JPopupMenu {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new instance of JCustomGraphPopup
	 * 
	 * @throws ResourceNotFoundException
	 */
	public JCustomGraphPopup() throws ResourceNotFoundException {
		initComponents();
		initActions();
	}

	/**
	 * Initialise form components
	 */
	@SuppressWarnings("unused")
	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		// Generated using JFormDesigner non-commercial license
		ResourceBundle bundle = ResourceBundle.getBundle("bundle.jgraph");
		jCopyMenuItem = new JMenuItem();
		jPasteMenuItem = new JMenuItem();
		jDeleteMenuItem = new JMenuItem();

		//======== this ========
		setName("this");

		//---- jCopyMenuItem ----
		jCopyMenuItem.setText("text");
		jCopyMenuItem.setName("jCopyMenuItem");
		add(jCopyMenuItem);

		//---- jPasteMenuItem ----
		jPasteMenuItem.setText("text");
		jPasteMenuItem.setName("jPasteMenuItem");
		add(jPasteMenuItem);
		addSeparator();

		//---- jDeleteMenuItem ----
		jDeleteMenuItem.setText("text");
		jDeleteMenuItem.setName("jDeleteMenuItem");
		add(jDeleteMenuItem);
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	// Generated using JFormDesigner non-commercial license
	private JMenuItem jCopyMenuItem;
	private JMenuItem jPasteMenuItem;
	private JMenuItem jDeleteMenuItem;
	// JFormDesigner - End of variables declaration //GEN-END:variables

	// ----------------------------------------------------------------------------------------
	// ---- Private helper methods

	/**
	 * Initialize actions
	 * 
	 * @throws ResourceNotFoundException thrown when initialization fails
	 */
	private void initActions() throws ResourceNotFoundException {
		ActionHelper.setAction(jCopyMenuItem, ActionFactory.getAction(GraphActionType.COPY), true);

		ActionHelper.setAction(jPasteMenuItem, ActionFactory.getAction(GraphActionType.PASTE),
				false);

		ActionHelper.setAction(jDeleteMenuItem, ActionFactory.getAction(GraphActionType.DELETE),
				true);
	}

}
