package pl.psnc.graph.action;

import java.awt.event.ActionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.graph.action.factory.AbstractGraphAction;
import pl.psnc.graph.action.factory.GraphActionType;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.image.ImageKeys;
import pl.psnc.vlab.util.gui.action.factory.ActionFactory;

/**
 * {@link ZoomActualAction} class - zoom actual action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ZoomActualAction extends AbstractGraphAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	private Log log = LogFactory.getLog(ZoomActualAction.class);

	/**
	 * Creates a new instance of zoom actual Action. The action is created with
	 * the default name, icons, mnemonic and accelerator key - these are taken
	 * from the resource bundle
	 */
	public ZoomActualAction() {
		super("action.zoom.actual.name", ImageKeys.ACTUAL_SIZE, "action.zoom.actual.tip");
		setMnemonic("action.zoom.actual.mnemonic");
		setAcceleratorKey("action.zoom.actual.shortcut");
		setDisabledActionIcon(ImageKeys.ACTUAL_SIZE_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			CustomGraph graph = getCurrentGraph();
			// graph.setResizeAction(null);
			double scale = graph.getScale();
			if (scale == 1.0) {
				return;
			}
			graph.setScale(1.0);
			scrollCellToVisible(graph);
			ActionFactory.getAction(GraphActionType.ZOOM_OUT).setEnabled(true);
			ActionFactory.getAction(GraphActionType.ZOOM_IN).setEnabled(true);
		} catch (Exception err) {
			log.error("Error" + err.getMessage());
		}
	}

	/**
	 * Scrolls the cell to the given scale
	 * 
	 * @param graph instance of {@link CustomGraph}
	 */
	private void scrollCellToVisible(CustomGraph graph) {
		Object selectionCells[] = graph.getSelectionCells();
		if (selectionCells != null) {
			graph.scrollCellToVisible(selectionCells);
		}
	}

}
