package pl.psnc.graph.action;

import java.awt.event.ActionEvent;

import pl.psnc.graph.action.factory.AbstractGraphAction;
import pl.psnc.graph.util.image.ImageKeys;

/**
 * {@link UndoAction} class - represents the undo action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class UndoAction extends AbstractGraphAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new instance of undo Action. The action is created with the
	 * default name, icons, mnemonic and accelerator key - these are taken from
	 * the resource bundle
	 */
	public UndoAction() {
		super("action.undo.name", ImageKeys.UNDO, "action.undo.tip");
		setMnemonic("action.undo.mnemonic");
		setAcceleratorKey("action.undo.shortcut");
		setDisabledActionIcon(ImageKeys.UNDO_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		// TransferHandler.getundoAction().actionPerformed( new
		// ActionEvent(getCurrentGraph(), e.getID() , e.getActionCommand() ));

	}
}
