package pl.psnc.graph.action;

import java.awt.event.ActionEvent;

import pl.psnc.graph.action.factory.AbstractGraphAction;
import pl.psnc.graph.util.image.ImageKeys;

/**
 * {@link RedoAction} class - represents the redo action
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class RedoAction extends AbstractGraphAction {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Instance of logger */
	// private Log log = LogFactory.getLog(this.getClass().getName());
	/**
	 * Creates a new instance of redo Action. The action is created with the
	 * default name, icons, mnemonic and accelerator key - these are taken from
	 * the resource bundle
	 */
	public RedoAction() {
		super("action.redo.name", ImageKeys.REDO, "action.redo.tip");
		setMnemonic("action.redo.mnemonic");
		setAcceleratorKey("action.redo.shortcut");
		setDisabledActionIcon(ImageKeys.REDO_DISABLED);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {

	}
}
