/*
 * TimeZoneToolsTest.java
 * JUnit based test
 *
 * Created on December 13, 2005, 4:59 PM
 */

package pl.psnc.vlab.util;

import junit.framework.*;
import java.util.*;
import java.text.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 *
 * @author @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 */
public class TimeZoneToolsTest extends TestCase {
    
    private TimeZoneTools timeZoneTools;
    private DateTools dateTools;
    
    private final static int ONE_HOUR = 60 * 60 * 1000;
    
    public TimeZoneToolsTest(String testName) {
        super(testName);
        this.timeZoneTools = new TimeZoneTools();
        dateTools = new DateTools(null, "dd/MM/yyyy", "kk:mm:ss");
    }
    
    protected void setUp() throws Exception {
    }
    
    protected void tearDown() throws Exception {
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(TimeZoneToolsTest.class);
        
        return suite;
    }
    
    /**
     * Test of getTimeZoneOffset method, of class pl.psnc.vlab.util.TimeZoneTools.
     */
    public void testGetTimeZoneOffset() {
        System.out.println("testGetTimeZoneOffset");
        TimeZone current = TimeZone.getTimeZone("GMT+0200");
        TimeZone base    = TimeZone.getTimeZone("GMT+0100");
        System.out.println("Current="+current);
        System.out.println("Base="+base);
        assertEquals(-1 ,  timeZoneTools.getTimeZoneOffset(current, base) / ONE_HOUR);
        
        current = TimeZone.getTimeZone("GMT-0400");        
        assertEquals(5 ,  timeZoneTools.getTimeZoneOffset(current, base) / ONE_HOUR);
        
        current = TimeZone.getTimeZone("GMT+0430");        
        assertEquals(-12600000 ,  timeZoneTools.getTimeZoneOffset(current, base) );
        
    }

    /**
     * Test of adjustTime method, of class pl.psnc.vlab.util.TimeZoneTools.
     */
    public void testAdjustTime() {
        System.out.println("testAdjustTime");
        TimeZone baseTz = TimeZone.getTimeZone("GMT+1");
        TimeZone curTz = TimeZone.getTimeZone("GMT-4");
                
        
        Date expect = dateTools.setTime(
                dateTools.getDateFromString("15/07/2005"),
                dateTools.getTimeFromString("19:20:00"));
        
        Date time = dateTools.setTime(
                dateTools.getDateFromString("15/07/2005"),
                dateTools.getTimeFromString("14:20:00"));
        
        assertEquals(expect, timeZoneTools.adjustTime(time, baseTz, curTz));
        
        
        
        expect = dateTools.setTime(
                dateTools.getDateFromString("01/01/2006"),
                dateTools.getTimeFromString("04:20:00"));
        
        time = dateTools.setTime(
                dateTools.getDateFromString("31/12/2005"),
                dateTools.getTimeFromString("23:20:00"));
        
                
        assertEquals(expect, timeZoneTools.adjustTime(time, baseTz, curTz));
        
    }

    /**
     * Test of getTimeZone method, of class pl.psnc.vlab.util.TimeZoneTools.
     */
    public void testGetTimeZone() {
        System.out.println("testGetTimeZone");
        TimeZone baze = TimeZone.getTimeZone("GMT+1");
        assertEquals(baze, timeZoneTools.getTimeZone("(GMT +01:00) Sarajevo, Scopje, Warsaw, Zagreb"));
        
        baze = TimeZone.getTimeZone("GMT");
        assertEquals(baze, timeZoneTools.getTimeZone("(GMT) Dublin, Edingurgh, Lisbon, London"));
        
        baze = TimeZone.getTimeZone("GMT-6");
        assertEquals(baze, timeZoneTools.getTimeZone("(GMT -06:00) Saskatchewan"));
        
        baze = TimeZone.getTimeZone("GMT-04:20");
        assertEquals(baze, timeZoneTools.getTimeZone("(GMT -04:20) Saskatchewan"));
        
        
    }
    
}
