package pl.psnc.vlab.util.thread;

import javax.swing.JComponent;

import pl.psnc.vlab.util.thread.DefaultLongTask;
import pl.psnc.vlab.util.thread.LongTaskResult;

/**
 * {@link LongTaskResult} class - used be the {@link DefaultLongTask} SwingWorker
 * class to wrap result information from the background threads.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 *
 */
public class LongTaskResult {

	/**
	 * Stores an instance of component which should received focus when tasks is
	 * over
	 */
	private JComponent focusableComponent;

	/** Stores message to display */
	private String message;

	/** Tells whether to save form components states */
	private boolean saveStates;

	/**
	 * Creates a new instance of {@link LongTaskResult}
	 * 
	 */
	public LongTaskResult() {
	}

	/**
	 * Creates a new instance of {@link LongTaskResult} with message key defined
	 * 
	 * @param message Stores an instance of localized message key
	 */
	public LongTaskResult(String message) {
		this(message, false, null);
	}

	/**
	 * Creates a new instance of {@link LongTaskResult} with message key and
	 * flag which indicates whether to save form components states
	 * 
	 * @param message Stores an instance of localized message key
	 * @param saveStates Tells whether to save form components states
	 */
	public LongTaskResult(String message, boolean saveStates) {
		this(message, saveStates, null);
	}

	/**
	 * Creates a new instance of {@link LongTaskResult} with message key,
	 * focusable component defined
	 * 
	 * @param message Stores an instance of localized message key
	 * @param focusableComponent Stores an instance of component which should
	 *            received focus when tasks is over
	 */
	public LongTaskResult(String message, JComponent focusableComponent) {
		this(message, false, focusableComponent);
	}

	/**
	 * Creates a new instance of {@link LongTaskResult} with message key,
	 * focusable component defined and flag which indicates whether to save form
	 * components states
	 * 
	 * @param message Stores an instance of localized message key
	 * @param saveStates Tells whether to save form components states
	 * @param focusableComponent Stores an instance of component which should
	 *            received focus when tasks is over
	 */
	public LongTaskResult(String message, boolean saveStates,
			JComponent focusableComponent) {
		this.message = message;
		this.saveStates = saveStates;
		this.focusableComponent = focusableComponent;
	}

	// -------------------------------------------------------------------------
	// ---- Getters / Setters

	/**
	 * Get value of focusableComponent
	 * 
	 * @return the focusableComponent
	 */
	public JComponent getFocusableComponent() {
		return focusableComponent;
	}

	/**
	 * Set value of field focusableComponent
	 * 
	 * @param focusableComponent the focusableComponent to set
	 */
	public void setFocusableComponent(JComponent focusableComponent) {
		this.focusableComponent = focusableComponent;
	}

	/**
	 * Get value of message
	 * 
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * Set value of field message
	 * 
	 * @param message the message to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * Get value of saveStates
	 * 
	 * @return the saveStates
	 */
	public boolean isSaveStates() {
		return saveStates;
	}

	/**
	 * Set value of field saveStates
	 * 
	 * @param saveStates the saveStates to set
	 */
	public void setSaveStates(boolean saveStates) {
		this.saveStates = saveStates;
	}

}
