/*
 * WfmActionHelper.java
 *
 * Created on December 16, 2005, 1:04 PM
 *
 */

package pl.psnc.vlab.util.swing.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

import javax.swing.JComponent;

/**
 * Class contains a set of util methods for the Swing components
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public final class GuiTools {

	/** Holds key of disabledIcon property */
	public static final String PROPERTY_DISABLED_ICON = "disabledIconKey";

	/** Stores instance of field: HYPER_LINK_COLOR */
	public static Color HYPER_LINK_COLOR = Color.blue;

	/** Stores instance of field: REGULAR_LINK_COLOR */
	public static Color REGULAR_LINK_COLOR = Color.black;

	/**
	 * Make hyper link
	 * 
	 * @param comp component
	 * @return hyper link
	 */
	public static JComponent makeHyperLink(JComponent comp) {
		if (comp == null) {
			return null;
		}
		comp.setForeground(HYPER_LINK_COLOR);
		comp.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		return comp;
	}

	/**
	 * Removes hyper link from the given component
	 * 
	 * @param comp component instance
	 * @return current component
	 */
	public static JComponent removeHyperLink(JComponent comp) {
		if (comp == null) {
			return null;
		}
		// Font f = comp.getFont();
		// f = f.deriveFont(Font.PLAIN);
		// comp.setFont(f);
		comp.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		comp.setForeground(REGULAR_LINK_COLOR);
		return comp;
	}

	/**
	 * Center given component on the screen
	 * 
	 * @param component component to be centered
	 */
	public static void center(Component component) {
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		Rectangle compSize = component.getBounds();
		component.setLocation((screen.width - compSize.width) / 2,
				(screen.height - compSize.height) / 2);
	}
}
