/*
 * AbstractDefaultObservableTableModel.java
 *
 */
package pl.psnc.vlab.util.gui.model.table;

import java.util.Observable;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * {@link AbstractDefaultObservableTableModel} class - abstract table model
 * class. This abstract class provides default implementations for most of the
 * methods in the TableModel interface. The class provides also notification
 * mechanism for changes in the model data
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class AbstractDefaultObservableTableModel extends AbstractDefaultTableModel {

	/** Stores Logger instance */
	private final Log log = LogFactory.getLog(getClass());

	/** Inner class - stores Observable instance */
	private Observable observable;

	/**
	 * Creates a new instance of AbstractDefaultObservableTableModel
	 * 
	 */
	public AbstractDefaultObservableTableModel() {
		this.observable = new ModelObservable();
	}

	/**
	 * Creates a new instance of AbstractDefaultObservableTableModel with column
	 * names specified.
	 * 
	 * 
	 * @param columnNames column names
	 * @param editable specifies whether column is editable
	 */
	public AbstractDefaultObservableTableModel(String columnNames[], boolean editable[]) {
		super(columnNames, editable);
		this.observable = new ModelObservable();
	}

	// --------------------------------------------------------------------------
	// ----- Helper methods

	/**
	 * Get model Observable instance
	 * 
	 * @return the observable
	 */
	public Observable getObservable() {
		return observable;
	}

	// --------------------------------------------------------------------------
	// ----- Observable interface

	/**
	 * {@link ModelObservable} class - class is used as a model observer
	 * 
	 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
	 * @email osa@man.poznan.pl
	 * 
	 */
	public class ModelObservable extends Observable implements TableModelListener {

		/**
		 * Creates new ModelObserver
		 */
		public ModelObservable() {
			log.debug("Creating ModelObserver");
			addTableModelListener(this);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see java.util.Observable#setChanged()
		 */
		@Override
		public synchronized void setChanged() {
			super.setChanged();
		}

		@Override
		public void tableChanged(TableModelEvent tModelEvent) {
			((ModelObservable) observable).setChanged();
			observable.notifyObservers(tModelEvent);
		}

	}

}