/**
 * 
 */
package pl.psnc.vlab.util.gui.model.info;

import java.util.Comparator;

import pl.psnc.vlab.util.i18n.BundleHelper;
import pl.psnc.vlab.util.i18n.BundleInfo;

/**
 * {@link ColumnType} class - describes JTable column type. Each column is
 * described by column name, type. Column names are internationalised.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class ColumnType implements BundleInfo, ColumnInfo {

	/** Stores column name */
	private String name;

	/** Stores column type */
	private Class<?> type;

	/** Stores column decorator */
	private ColumnDecorator decorator;

	/** Stores instance of field: comparator */
	private Comparator<?> comparator;

	/** Stores instance of field: bundleHelper */
	protected BundleHelper bundleHelper;

	/**
	 * Creates new ColumnType
	 * 
	 * @param nameKey column name i18n key
	 * @param type column type
	 */
	public ColumnType(String nameKey, Class<?> type) {
		this(nameKey, type, null);
	}

	/**
	 * Creates new ColumnType
	 * 
	 * @param nameKey column name i18n key
	 * @param type column type
	 * @param decorator decorator class
	 */
	public ColumnType(String nameKey, Class<?> type, ColumnDecorator decorator) {
		this(nameKey, type, decorator, null);
	}

	/**
	 * Creates new ColumnType
	 * 
	 * @param nameKey column name i18n key
	 * @param type column type
	 * @param decorator decorator class
	 * @param comparator comparator class
	 */
	public ColumnType(String nameKey, Class<?> type, ColumnDecorator decorator,
			Comparator<?> comparator) {
		this.bundleHelper = new BundleHelper(getBundle());
		this.name = bundleHelper.getI18nValue(nameKey);
		this.type = type;
		this.decorator = decorator;
		this.comparator = comparator;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Enum#toString()
	 */
	@Override
	public String toString() {
		return this.name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.i18n.BundleInfo#getBundle()
	 */
	@Override
	public abstract String getBundle();

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.model.info.ColumnInfo#getColumnType()
	 */
	@Override
	public ColumnType getColumnType() {
		return this;
	}

	// -------------------------------------------------------------------------
	// ----- Getters

	/**
	 * Get ColumnType name
	 * 
	 * @return column name
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * Get value of type
	 * 
	 * @return the type
	 */
	public Class<?> getType() {
		return type;
	}

	/**
	 * Get value of decorator
	 * 
	 * @return the decorator
	 */
	public ColumnDecorator getDecorator() {
		return decorator;
	}

	/**
	 * Get value of field: comparator
	 * 
	 * @return the comparator
	 */
	public Comparator<?> getComparator() {
		return comparator;
	}

}
