/**
 * 
 */
package pl.psnc.vlab.util.gui.action;

import javax.swing.ImageIcon;

/**
 * ActionDecorator Interface. Defines a set of methods which can be called to
 * decorate AbstractAction
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface ActionDecorator {
	/** The parent object of this action */
	public final static String PARENT_OBJECT = "parentObject";

	/** Holds key of disabledIcon property */
	public static final String DISABLED_ICON = "disabledIconKey";

	/**
	 * Get action name
	 * 
	 * @return action name
	 */
	public String getName();

	/**
	 * Set action name
	 * 
	 */
	public void setName(String name);

	/**
	 * Set short description for this ActionDecorator
	 * 
	 * @param description short description
	 */
	public void setShortDescription(String description);

	/**
	 * Get short description for this ActionDecorator
	 * 
	 * @return short description for this ActionDecorator
	 */
	public String getShortDescription();

	/**
	 * Set disabled icon for this ActionDecorator
	 * 
	 * @param icon disabled action
	 */
	public void setDisabledActionIcon(ImageIcon icon);

	/**
	 * Get disabled icon for this ActionDecorator
	 * 
	 * @return disabled icon for this ActionDecorator
	 */
	public ImageIcon getDisabledActionIcon();

	/**
	 * Set Mnemonic key. The key used for storing an int key code to be used as
	 * the mnemonic for the action.
	 * 
	 * @param mnemonic mnemonic
	 */
	public void setMnemonic(char mnemonic);

	/**
	 * Set Accelerator key. The key used for storing a KeyStroke to be used as
	 * the accelerator for the action.
	 * 
	 * @param accelerator accelerator
	 */
	public void setAcceleratorKey(String accelerator);

}
