package pl.psnc.vlab.util.gui.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

/**
 * AbstractActionDefault - this class provides default implementations for the
 * JFC Action interface
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class AbstractActionDefault extends AbstractAction implements ActionDecorator {

	/**
	 * Define an Action Object with a specified action name and icon.
	 * 
	 * @param name name of the action
	 * @param icon the icon for the current action
	 */
	public AbstractActionDefault(String name, Icon icon) {
		this(name, icon, null);
	}

	/**
	 * Define an Action Object with a specified action name, icon and short
	 * description.
	 * 
	 * @param name name of the action
	 * @param icon the icon for the current action
	 * @param description action short description
	 */
	public AbstractActionDefault(String name, Icon icon, String description) {
		super(name, icon);
		setShortDescription(description);
	}

	/**
	 * Define an Action Object with a specified action icon.
	 * 
	 * @param icon the icon for the current action
	 */
	public AbstractActionDefault(Icon icon) {
		this("", icon, "");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.ActionDecorator#getName()
	 */
	public String getName() {
		return (String) getValue(NAME);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.ActionDecorator#setName(java.lang.String)
	 */
	public void setName(String name) {
		putValue(NAME, name);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public abstract void actionPerformed(ActionEvent e);

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.ActionDecorator#setAcceleratorKey(java.lang.String)
	 */
	public void setAcceleratorKey(String accelerator) {
		this.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(accelerator));

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.ActionDecorator#setDisabledActionIcon(javax.swing.ImageIcon)
	 */
	public void setDisabledActionIcon(ImageIcon icon) {
		this.putValue(DISABLED_ICON, icon);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.ActionDecorator#getDisabledActionIcon()
	 */
	public ImageIcon getDisabledActionIcon() {
		Object value = getValue(DISABLED_ICON);
		if (value instanceof ImageIcon) {
			return (ImageIcon) value;
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.ActionDecorator#setMnemonic(char)
	 */
	public void setMnemonic(char mnemonic) {
		Integer code = Integer.valueOf(KeyStroke.getKeyStroke(mnemonic).getKeyCode());
		this.putValue(MNEMONIC_KEY, code);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.ActionDecorator#setShortDescription(java.lang.String)
	 */
	public void setShortDescription(String description) {
		this.putValue(SHORT_DESCRIPTION, description);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pl.psnc.vlab.util.gui.action.ActionDecorator#getShortDescription()
	 */
	public String getShortDescription() {
		return (String) getValue(SHORT_DESCRIPTION);
	}

	/**
	 * Set icon for the specified action
	 */
	public void setIcon(Icon icon) {
		putValue(Action.SMALL_ICON, icon);
	}

}
