package pl.psnc.vlab.util.collection;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * {@link CollectionHelper} class - set of utility classes to work with
 * collections and arrays.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CollectionHelper {

	/**
	 * Converts map with list of string as values to map with string as value.
	 * 
	 * @param data collection data
	 * @param numberOfValues number of values
	 * @return converted map
	 */
	public static String[][] convert(Map<String, List<String>> data, int numberOfValues) {
		if (data == null) {
			return null;
		}

		Set<String> keySet = data.keySet();
		if (keySet == null) {
			return null;
		}

		int size = 0;
		for (String key : keySet) {
			List<String> list = data.get(key);
			int lSize = list != null ? list.size() : 0;
			size += lSize / numberOfValues;
		}

		String[][] result = new String[size][numberOfValues+1];

		int counter = 0;
		for (String key : keySet) {
			List<String> list = data.get(key);
			int index = 1;
			int vSize = list != null ? list.size() : 0;
			for (int i=0; i<vSize; i++) {				
				result[counter][0] = key;
				result[counter][index++] = list.get(i);
				if (i == numberOfValues-1 || i == vSize -1){
					counter++;
					index = 1;
				}
			}
			
		} // end of for
		return result;
	}
}
