/*
 * TimeZoneTools.java
 *
 * Created on 10 grudzie� 2002, 21:33
 */

package pl.psnc.vlab.util;

import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * {@link TimeZoneTools} class - set of util methods used to operate on time
 * zones.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class TimeZoneTools {

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/**
	 * Calculates the time offset between two timezones. The result is in
	 * miliseconds
	 * 
	 * @param currentTimeZone first timezone
	 * @param baseTimeZone second timezone
	 * @return offset between timezones
	 */
	public int getTimeZoneOffset(TimeZone currentTimeZone, TimeZone baseTimeZone) {
		return baseTimeZone.getRawOffset() - currentTimeZone.getRawOffset();
	}

	/**
	 * Adjust the given date object from the current time zone to the specified
	 * base time zone
	 * 
	 * @param time date object to be converted
	 * @param baseTimeZone base time zone
	 * @param currentTimeZone current time zone
	 * @return adjusted date object
	 */
	public Date adjustTime(Date time, TimeZone baseTimeZone, TimeZone currentTimeZone) {
		int offset = getTimeZoneOffset(currentTimeZone, baseTimeZone);
		return new Date(time.getTime() + offset);
	}

	/**
	 * Parse the given time zone as a string
	 * 
	 * @param timeZone time zone
	 * @return TimeZone object created from the string representation
	 */
	public TimeZone getTimeZone(String timeZone) {
		log.debug("<getTimeZone: " + timeZone + ">");
		if (timeZone == null) {
			return TimeZone.getDefault();
		}
		// get the firt part to the ) signd
		StringTokenizer st = new StringTokenizer(timeZone, ")");
		String firstToken = st.nextToken();
		log.debug("FirstToken=" + firstToken);
		// remove the first char "("
		firstToken = firstToken.substring(1);
		// remove spaces if they exist
		String firstSplitted[] = firstToken.split(" ");
		int size = firstSplitted != null ? firstSplitted.length : 0;
		StringBuffer res = new StringBuffer(firstToken.length());
		for (int i = 0; i < size; i++) {
			res.append(firstSplitted[i]);
		}
		log.debug("timeZOne=" + res);
		log.debug("</getTimeZone>");
		return TimeZone.getTimeZone(res.toString());
	}
}
