/*
 * FormTools.java
 *
 * Created on 22 sierpie� 2001, 15:39
 */

package pl.psnc.vlab.util;

/**
 * {@link FormTools} class - contains various helper methods which checks the
 * correctness of specified data types i.e. whether specified value is valid
 * String, int, long value. There is also a set of methods which acts on swing
 * components
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class FormTools {

	/**
	 * Checks whether the string value is a number
	 * 
	 * @param value string value
	 * @return <CODE>true</CODE>/<CODE>false</CODE>
	 */
	public static boolean isValidateStringNumber(String value) {
		return isValidateStringDouble(value) || isValidateStringInteger(value)
				|| isValidateStringLong(value);
	}

	/**
	 * Checks whether the string value is a type of Integer
	 * 
	 * @param value string value
	 * @return <CODE>true</CODE> if it is Integer, <CODE>false</CODE>
	 *         otherwise
	 */
	public static boolean isValidateStringInteger(String value) {
		try {
			Integer.parseInt(value);
			return true;
		} catch (NumberFormatException err) {
			return false;
		}
	}

	/**
	 * Checks whether the string value is a type of Long
	 * 
	 * @param value string value
	 * @return <CODE>true</CODE> if it is Long, <CODE>false</CODE> otherwise
	 */
	public static boolean isValidateStringLong(String value) {
		try {
			Long.parseLong(value);
			return true;
		} catch (NumberFormatException err) {
			return false;
		}
	}

	/**
	 * Checks whether the string value is a type of Double
	 * 
	 * @param value string value
	 * @return <CODE>true</CODE> if it is Double, <CODE>false</CODE>
	 *         otherwise
	 */
	public static boolean isValidateStringDouble(String value) {
		try {
			Double.parseDouble(value);
			return true;
		} catch (NumberFormatException err) {
			return false;
		}
	}

	/**
	 * Tests whether the validate string is null
	 * 
	 * @param value the string value
	 * @return <CODE>true</CODE> if is not empty, <CODE>false</CODE>,
	 *         otherwise
	 */
	public static boolean isValidateFormStringNull(String value) {
		if (value == null)
			return true;
		else if (value == "")
			return true;
		else if ("".equals(value))
			return true;
		else if (value.length() == 0)
			return true;
		else
			return false;
	}

	/**
	 * Change string value to upper. Letters and digits are allowed
	 * 
	 * @param s string value
	 * @return string value changed to upper case.
	 */
	public static String toUpperLetterAndDigit(String s) {
		StringBuffer str = new StringBuffer();

		int len = (s != null) ? s.length() : 0;
		for (int i = 0; i < len; i++) {
			char ch = s.charAt(i);
			if (Character.isLetter(ch)) {
				str.append(Character.toUpperCase(ch));
			} else if (Character.isDigit(ch)) {
				str.append(ch);
			}
		}
		return (str.toString());
	}

}
