/*
 * StatusBar.java
 *
 * Created on 4 maj 2002, 15:21
 */

package pl.psnc.vlab.statusbar;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

import javax.swing.ImageIcon;
import javax.swing.JProgressBar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.util.DateTools;
import pl.psnc.vlab.util.TimeZoneTools;
import pl.psnc.vlab.util.image.ImageBean;
import pl.psnc.vlab.util.image.ImageFactory;

/**
 * {@link JStatusBar} class - The Swing Status Bar component
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * @deprecated {@link pl.psnc.vlab.util.gui.progress.JStatusBar} should be used instead
 * 
 */
public class JStatusBar extends javax.swing.JPanel {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Logger instance */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** Icon, which represents summer time */
	private String SUMMER_TIME_ICON = "images/summer_time_16.png";

	/** Icon, which represents winter time */
	private String WINTER_TIME_ICON = "images/winter_time_16.png";

	/** Specifies the location of country flags */
	private static final String FLAGS_PATH = "images/flags/";

	/** Specifies the extension of the country flag file */
	private static final String FLAG_FILE_TYPE = ".gif";

	/** Holds value of the current TimeZone */
	private TimeZone currentTimeZone;

	/** Holds value of the base TimeZone */
	private TimeZone baseTimeZone;

	/** The locale of the application */
	private Locale locale = null;

	/** Instance of date tools */
	private DateTools dateTools = null;

	/** Number formatter */
	private NumberFormat nf = null;

	/** Message shown in the status */
	private String message = "";

	/** Stores the base date */
	private Date baseDate;

	/** Tells whether time should be adjusted according to the TimeZone */
	private boolean adjust;

	/** is is summer time */
	private boolean isSummerTime;

	/**
	 * Creates a new instance of {@link JStatusBar}
	 */
	public JStatusBar() {

	}

	/**
	 * Creates new Status Bar with the locale, current time zone (the one
	 * selected by the user), base time zone (the one set as a base time zone)
	 * and summer time flag
	 * 
	 * @param isSummerTime
	 * @param currentTimeZone
	 * @param baseTimeZone
	 * @param locale
	 */
	public JStatusBar(Locale locale, TimeZone currentTimeZone, TimeZone baseTimeZone,
			boolean isSummerTime) {
		this(locale);
		this.currentTimeZone = currentTimeZone;
		this.baseTimeZone = baseTimeZone;
		this.isSummerTime = isSummerTime;
		// encode date
		setTimeZone(baseTimeZone);
		adjust = true;
		setTime();
		setDate();
	}

	/**
	 * Creates new Status Bar with the locale, current time zone (the one
	 * selected by the user), base time zone (the one set as a base time zone)
	 * and summer time flag
	 * 
	 * @param currentTimeZone current time zone
	 * @param baseTimeZone base time zone
	 */
	public JStatusBar(TimeZone currentTimeZone, TimeZone baseTimeZone) {
		this(null);
		this.currentTimeZone = currentTimeZone;
		this.baseTimeZone = baseTimeZone;
		adjust = true;
		setTime();
		setDate();
	}

	/**
	 * Creates new form StatusBar
	 * 
	 * @param locale
	 */
	public JStatusBar(Locale locale) {
		initComponents();

		if (locale != null) {
			this.locale = locale;
		} else {
			this.locale = Locale.getDefault();
		}

		this.dateTools = new DateTools(locale, "dd MMMM, yyyy", "kk:mm:ss");
		this.nf = NumberFormat.getInstance();
		nf.setMaximumFractionDigits(0);

		jProgress.setStringPainted(true);
		jProgress.setForeground(Color.black);
		jProgress.setUI(new javax.swing.plaf.basic.BasicProgressBarUI() {
			public Color getSelectionBackground() {
				return Color.black;
			}

			public Color getSelectionForeground() {
				return Color.white;
			}
		});

		// set margins
		((java.awt.CardLayout) jMessagePanel.getLayout()).setHgap(5);
		((java.awt.CardLayout) jUserPanel.getLayout()).setHgap(5);
		// set flag
		setLanguage();
		// detach progres bar
		detachProgressBar();
		this.baseDate = new Date();
		setTime();
		setDate();

	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code
	// ">//GEN-BEGIN:initComponents
	private void initComponents() {
		timer = new org.netbeans.examples.lib.timerbean.Timer();
		jMessagePanel = new javax.swing.JPanel();
		jMessage = new javax.swing.JLabel();
		jProgresBar = new javax.swing.JPanel();
		jProgress = new javax.swing.JProgressBar();
		jLanguagePane = new javax.swing.JPanel();
		jPanel1 = new javax.swing.JPanel();
		jLanguage = new javax.swing.JLabel();
		jUserPanel = new javax.swing.JPanel();
		jUser = new javax.swing.JLabel();
		jDatePanel = new javax.swing.JPanel();
		jDate = new javax.swing.JLabel();
		jTimePanel = new javax.swing.JPanel();
		jTimeIcon = new javax.swing.JLabel();
		jPanel3 = new javax.swing.JPanel();
		jTime = new javax.swing.JLabel();
		jPanel4 = new javax.swing.JPanel();
		jTimeZone = new javax.swing.JLabel();
		jSummerTimeLbl = new javax.swing.JLabel();

		timer.addTimerListener(new org.netbeans.examples.lib.timerbean.TimerListener() {
			public void onTime(java.awt.event.ActionEvent evt) {
				timerOnTime(evt);
			}
		});

		setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.X_AXIS));

		setAlignmentX(0.0F);
		setAlignmentY(1.0F);
		setMaximumSize(new java.awt.Dimension(32767, 20));
		setMinimumSize(new java.awt.Dimension(200, 20));
		setPreferredSize(new java.awt.Dimension(400, 20));
		setRequestFocusEnabled(false);
		jMessagePanel.setLayout(new java.awt.CardLayout());

		jMessagePanel.setBorder(new javax.swing.border.SoftBevelBorder(
				javax.swing.border.BevelBorder.LOWERED));
		jMessagePanel.setAlignmentX(1.0F);
		jMessagePanel.setMaximumSize(new java.awt.Dimension(1000, 20));
		jMessagePanel.setMinimumSize(new java.awt.Dimension(80, 20));
		jMessagePanel.setPreferredSize(new java.awt.Dimension(300, 20));
		jMessage.setToolTipText("");
		jMessagePanel.add(jMessage, "card3");

		add(jMessagePanel);

		jProgresBar.setLayout(new java.awt.CardLayout());

		jProgresBar.setBorder(new javax.swing.border.SoftBevelBorder(
				javax.swing.border.BevelBorder.LOWERED));
		jProgresBar.setAlignmentX(1.0F);
		jProgresBar.setMaximumSize(new java.awt.Dimension(800, 20));
		jProgresBar.setMinimumSize(new java.awt.Dimension(50, 20));
		jProgresBar.setPreferredSize(new java.awt.Dimension(200, 20));
		jProgress.setForeground(new java.awt.Color(255, 102, 102));
		jProgress.setAlignmentX(0.0F);
		jProgress.setAlignmentY(0.0F);
		jProgress.setMaximumSize(new java.awt.Dimension(500, 20));
		jProgress.setMinimumSize(new java.awt.Dimension(100, 20));
		jProgress.setPreferredSize(new java.awt.Dimension(300, 20));
		jProgress.setString("");
		jProgresBar.add(jProgress, "card2");

		add(jProgresBar);

		jLanguagePane.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 2, 2));

		jLanguagePane.setBorder(new javax.swing.border.SoftBevelBorder(
				javax.swing.border.BevelBorder.LOWERED));
		jLanguagePane.setToolTipText("");
		jLanguagePane.setAlignmentX(1.0F);
		jLanguagePane.setMaximumSize(new java.awt.Dimension(50, 20));
		jLanguagePane.setMinimumSize(new java.awt.Dimension(50, 20));
		jLanguagePane.setPreferredSize(new java.awt.Dimension(50, 20));
		jPanel1.setLayout(new java.awt.BorderLayout());

		jPanel1.setMaximumSize(new java.awt.Dimension(50, 12));
		jPanel1.setMinimumSize(new java.awt.Dimension(1, 12));
		jPanel1.setPreferredSize(new java.awt.Dimension(25, 12));
		jLanguage.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jLanguage.setToolTipText("");
		jPanel1.add(jLanguage, java.awt.BorderLayout.CENTER);

		jLanguagePane.add(jPanel1);

		add(jLanguagePane);

		jUserPanel.setLayout(new java.awt.CardLayout());

		jUserPanel.setBorder(new javax.swing.border.SoftBevelBorder(
				javax.swing.border.BevelBorder.LOWERED));
		jUserPanel.setToolTipText("");
		jUserPanel.setAlignmentX(1.0F);
		jUserPanel.setMaximumSize(new java.awt.Dimension(200, 20));
		jUserPanel.setMinimumSize(new java.awt.Dimension(50, 20));
		jUserPanel.setPreferredSize(new java.awt.Dimension(150, 20));
		jUserPanel.add(jUser, "card2");

		add(jUserPanel);

		jDatePanel.setLayout(new java.awt.CardLayout());

		jDatePanel.setBorder(new javax.swing.border.SoftBevelBorder(
				javax.swing.border.BevelBorder.LOWERED));
		jDatePanel.setToolTipText("");
		jDatePanel.setAlignmentX(1.0F);
		jDatePanel.setMaximumSize(new java.awt.Dimension(300, 20));
		jDatePanel.setMinimumSize(new java.awt.Dimension(100, 20));
		jDatePanel.setPreferredSize(new java.awt.Dimension(130, 20));
		jDate.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jDate.setAlignmentX(1.0F);
		jDate.setAlignmentY(0.0F);
		jDatePanel.add(jDate, "card2");

		add(jDatePanel);

		jTimePanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 3, 0));

		jTimePanel.setBorder(new javax.swing.border.SoftBevelBorder(
				javax.swing.border.BevelBorder.LOWERED));
		jTimePanel.setToolTipText("");
		jTimePanel.setAlignmentX(1.0F);
		jTimePanel.setMaximumSize(new java.awt.Dimension(260, 20));
		jTimePanel.setMinimumSize(new java.awt.Dimension(170, 20));
		jTimePanel.setPreferredSize(new java.awt.Dimension(245, 20));
		jTimeIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/clock.gif")));
		jTimeIcon.setMaximumSize(new java.awt.Dimension(20, 16));
		jTimeIcon.setMinimumSize(new java.awt.Dimension(20, 16));
		jTimeIcon.setPreferredSize(new java.awt.Dimension(20, 16));
		jTimePanel.add(jTimeIcon);

		jPanel3.setLayout(new java.awt.CardLayout());

		jPanel3.setMaximumSize(new java.awt.Dimension(80, 16));
		jPanel3.setMinimumSize(new java.awt.Dimension(55, 16));
		jPanel3.setPreferredSize(new java.awt.Dimension(65, 16));
		jTime.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jTime.setText("14:45:55");
		jTime.setAlignmentY(0.0F);
		jTime.setMaximumSize(new java.awt.Dimension(70, 16));
		jTime.setMinimumSize(new java.awt.Dimension(65, 16));
		jTime.setPreferredSize(new java.awt.Dimension(65, 16));
		jPanel3.add(jTime, "card3");

		jTimePanel.add(jPanel3);

		jPanel4.setLayout(new java.awt.CardLayout());

		jPanel4.setMaximumSize(new java.awt.Dimension(95, 16));
		jPanel4.setMinimumSize(new java.awt.Dimension(65, 16));
		jPanel4.setPreferredSize(new java.awt.Dimension(80, 16));
		jTimeZone.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jTimeZone.setText("GMT+01:00");
		jTimeZone.setAlignmentY(0.0F);
		jTimeZone.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
		jTimeZone.setMaximumSize(new java.awt.Dimension(90, 16));
		jTimeZone.setMinimumSize(new java.awt.Dimension(75, 16));
		jTimeZone.setPreferredSize(new java.awt.Dimension(85, 16));
		jPanel4.add(jTimeZone, "card3");

		jTimePanel.add(jPanel4);

		jSummerTimeLbl.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		jSummerTimeLbl.setIcon(new javax.swing.ImageIcon(
				"/home/osa/cvs/sources/vlabCommon/src/images/summer_time_16.png"));
		jSummerTimeLbl.setFocusable(false);
		jSummerTimeLbl.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
		jSummerTimeLbl.setMaximumSize(new java.awt.Dimension(25, 16));
		jSummerTimeLbl.setMinimumSize(new java.awt.Dimension(20, 16));
		jSummerTimeLbl.setPreferredSize(new java.awt.Dimension(25, 16));
		jTimePanel.add(jSummerTimeLbl);

		add(jTimePanel);

	}// </editor-fold>//GEN-END:initComponents

	private void timerOnTime(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_timerOnTime
		// Add your handling code here:
		setTime();
		updateMessage();
	}// GEN-LAST:event_timerOnTime

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JLabel jDate;
	private javax.swing.JPanel jDatePanel;
	private javax.swing.JLabel jLanguage;
	private javax.swing.JPanel jLanguagePane;
	private javax.swing.JLabel jMessage;
	private javax.swing.JPanel jMessagePanel;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jPanel3;
	private javax.swing.JPanel jPanel4;
	private javax.swing.JPanel jProgresBar;
	private javax.swing.JProgressBar jProgress;
	private javax.swing.JLabel jSummerTimeLbl;
	private javax.swing.JLabel jTime;
	private javax.swing.JLabel jTimeIcon;
	private javax.swing.JPanel jTimePanel;
	private javax.swing.JLabel jTimeZone;
	private javax.swing.JLabel jUser;
	private javax.swing.JPanel jUserPanel;
	private org.netbeans.examples.lib.timerbean.Timer timer;

	// End of variables declaration//GEN-END:variables

	// --------------------------------------------------------

	/**
	 * Sets the user name
	 * 
	 * @param message user name
	 */
	public void setUserName(String message) {
		StringBuffer userNameSb = new StringBuffer();
		userNameSb.append("<html>").append("<b>").append(
				java.util.ResourceBundle.getBundle("pl/psnc/vlab/statusbar/StatusBar").getString(
						"logged.user.name")).append("</b>").append(message).append("</html>");

		this.jUser.setToolTipText(userNameSb.toString());
		this.jUserPanel.setToolTipText(userNameSb.toString());
		this.jUser.setText(message);
	}

	/**
	 * Sets the message on the status bar
	 * 
	 * @param message message, which will be visible on the status bar
	 */
	public void setMessage(String message) {
		this.message = message;
		// jMessage.setText(message);
		// jMessage.repaint();
	}

	/**
	 * Sets the message on the status bar
	 * 
	 * @param message
	 */
	private void updateMessage() {
		jMessage.setText(this.message);
		jMessage.setToolTipText(this.message);
		jMessagePanel.setToolTipText(this.message);
	}

	// --------------------------------------------------------
	/**
	 * Sets the date on the status bar
	 */
	private void setDate() {
		jDate.setText(dateTools.getDateAsString(baseDate));
	}

	// --------------------------------------------------------
	/**
	 * Sets the time on the status bar
	 */
	public void setTime() {
		if (adjust) {
			this.baseDate = new TimeZoneTools().adjustTime(new Date(), baseTimeZone,
					currentTimeZone);
			if (isSummerTime) {
				this.baseDate = dateTools.add(this.baseDate, Calendar.HOUR, 1);
			}
		}
		jTime.setText(dateTools.getTimeAsString(baseDate));
	}

	/**
	 * Set the time icon on the time panel
	 * 
	 * @param icon
	 */
	public void setTimeIcon(ImageIcon icon) {
		jTimeIcon.setIcon(icon);
	}

	/**
	 * Set the selected time zone
	 * 
	 * @param timeZone
	 */
	public void setTimeZone(TimeZone timeZone) {
		try {
			String shortTZ = timeZone.getDisplayName(locale);
			jTimeZone.setText(shortTZ);
			StringBuffer timeZoneSb = new StringBuffer();
			timeZoneSb.append("<html>").append("<b>").append(
					ResourceBundle.getBundle("pl/psnc/vlab/statusbar/StatusBar").getString(
							"selected.time.zone")).append("</b>").append(timeZone)
					.append("</html>");

			if (isSummerTime) {
				jSummerTimeLbl.setIcon(ImageFactory.getImageBean(SUMMER_TIME_ICON).getImage());
				jSummerTimeLbl.setToolTipText(ResourceBundle.getBundle(
						"pl/psnc/vlab/statusbar/StatusBar").getString("summer.time.tooltip"));
			} else {
				jSummerTimeLbl.setIcon(ImageFactory.getImageBean(WINTER_TIME_ICON).getImage());
				jSummerTimeLbl.setToolTipText(ResourceBundle.getBundle(
						"pl/psnc/vlab/statusbar/StatusBar").getString("winter.time.tooltip"));
			}
			jTimeIcon.setToolTipText(timeZoneSb.toString());
			jTimePanel.setToolTipText(timeZoneSb.toString());

		} catch (Exception e) {
			log.error("Error while Time Zone initialization. Details:" + e.getMessage());

		}
	}

	/**
	 * Set the selected time zone
	 * 
	 * @param timeZone
	 */
	public void setTimeZone(String timeZone) {
		try {
			StringBuffer timeZoneSb = new StringBuffer();
			timeZoneSb.append("<html>").append("<b>").append(
					java.util.ResourceBundle.getBundle("pl/psnc/vlab/statusbar/StatusBar")
							.getString("selected.time.zone")).append("</b>").append(timeZone)
					.append("</html>");

			jTimeIcon.setToolTipText(timeZoneSb.toString());
			jTimePanel.setToolTipText(timeZoneSb.toString());
		} catch (Exception e) {
			log.error("Error while Time Zone initialization. Details:" + e.getMessage());

		}
	}

	// --------------------------------------------------------
	/**
	 * Paints the flag of the choosen language
	 */
	public void setLanguage() {
		jLanguage.setText("");
		StringBuffer langToolTip = new StringBuffer();
		langToolTip.append("<html>").append("<b>").append(
				java.util.ResourceBundle.getBundle("pl/psnc/vlab/statusbar/StatusBar").getString(
						"selected.language.name")).append("</b>").append(
				locale.getDisplayLanguage(locale)).append("<br><b>").append(
				java.util.ResourceBundle.getBundle("pl/psnc/vlab/statusbar/StatusBar").getString(
						"selected.country.name")).append("</b>").append(
				locale.getDisplayCountry(locale)).append("</html>");

		jLanguage.setToolTipText(langToolTip.toString());
		// set icon
		try {

			String flag = new StringBuffer(FLAGS_PATH).append(
					locale.getISO3Language().toLowerCase()).append(FLAG_FILE_TYPE).toString();
			ImageBean flagImg = ImageFactory.getImageBean(flag);
			jLanguage.setIcon(flagImg.getImage());
		} catch (Exception e) {
			// no icon
		}
	}

	// --------------------------------------------------------
	/**
	 * Sets the progress bar on the status bar
	 * 
	 * @param from min value of the ProgressBar
	 * @param to max value of the ProgressBar
	 */
	public void setProgress(int from, int to) {
		// jMessage.setVisible(false);
		jProgresBar.setVisible(true);
		jProgress.setVisible(true);
		jProgress.setMinimum(from);
		jProgress.setMaximum(to);
		jProgress.setValue(from);
		jProgress.setString("");
		jProgress.update(jProgress.getGraphics());
		jProgresBar.update(jProgresBar.getGraphics());
	}

	/**
	 * Sets the progress bar on the status bar
	 * 
	 * @param messg message
	 */
	public void attachIndeterminedProgressBar(String messg) {
		jProgresBar.setVisible(true);
		jProgress.setBorderPainted(true);
		jProgress.setIndeterminate(true);
		jProgress.setVisible(true);
		jProgress.setString(messg);
	}

	// --------------------------------------------------------
	/**
	 * Sets progres bar to given value
	 */
	public void updateProgressValue() {
		int val = jProgress.getValue();
		jProgress.setValue(val + 1);
		/*
		 * double procent =jProgress.getPercentComplete()*100;
		 * jProgress.setString(nf.format(procent)+" %");
		 * jProgress.update(jProgress.getGraphics());
		 */
	}

	// --------------------------------------------------------
	/**
	 * Sets progres bar to given value
	 * 
	 * @param value value
	 */
	public void updateProgressValue(int value) {
		if (value == jProgress.getValue()) {
			return;
		}
		jProgress.setValue(value);
		double procent = jProgress.getPercentComplete() * 100;
		jProgress.setString(nf.format(procent) + " %");
		jProgress.update(jProgress.getGraphics());
	}

	// --------------------------------------------------------
	/**
	 * Detaches the progress bar from the status bar
	 */
	public void detachProgressBar() {
		jProgress.setVisible(false);
		jProgresBar.setVisible(false);
	}

	/**
	 * Get the status bar progress bar
	 * 
	 * @return JProgressBar component
	 */
	public JProgressBar getProgressBar() {
		return this.jProgress;
	}

	/**
	 * Get the current date (adjusted to the selected time zone)
	 * 
	 * @return current date (adjusted to the selected time zone)
	 */
	public Date getCurrentDate() {
		return baseDate;
	}
}
