/*
 * VlabTaskStatus.java
 *
 * Created on 27 pa�dziernik 2004, 12:01
 */

package pl.psnc.vlab.remote.util;

/**
 *
 * @author  <a href="mailto:osa@man.poznan.pl">Dominik Stok�osa</a>
 */
public interface VlabTaskStatus {
    
    /** Pending: Task submitted to the system */
    public static final int STATUS_PENDING       = 1;   
    
    /** Scheduled: Task is scheduled locally */
    public static final int STATUS_SCHEDULED     = 2;   
    
    /** Init: Task is sent to its execution module (initialisation) */
    public static final int STATUS_INIT          = 3;   
    
    /** Ready: Task is ready for execution (only when interactive) */
    public static final int STATUS_READY         = 4;   
    
    /** InProgress: Task is in progress */
    public static final int STATUS_IN_PROGRESS   = 5;   
    
       
    /** Done: Task is done (success) */
    public static final int STATUS_DONE          = 6;  
    
    /** Failed: Task failed (error in execution) */
    public static final int STATUS_FAILED        = 7;
    
    /** Interrupted: Task interrupted by system */
    public static final int STATUS_INTERRUPTED   = 8;
    
    /** Archived: Task done and stored */
    public static final int STATUS_ARCHIVED      = 9; 
    
    /** Unschedulable: Task cannot be scheduled*/
    public static final int STATUS_UNSCHEDULABLE = 10;
    
    /** Closing: Task is being closed and device getting ready for the next exp */
    public static final int STATUS_CLOSING       = 11;
    
    /** Cost exceeded: Experiment cost is not acceptable */
    public static final int STATUS_COSTEXCEEDED  = 12;
    
    /** Accounting limits exceeded for the user/laboratory */
    public static final int STATUS_LIMITEXCEEDED = 13;
    
    /** Wrong data:  Wrong experiment reservation period data */
    public static final int STATUS_WRONGDATA     = 14;
        
    /** Buffered */
    public static final int STATUS_BUFFERED      = 15;
    
    /** Sample preparation */
    public static final int STATUS_SAMPLEPREP    = 16;
    
    /** Acces denied: RAD permission not granted*/
    public static final int STATUS_ACCESSDENIED  = 17;
            
    /** Invalid proxy:  Task has invalid proxy */
    public static final int STATUS_INVALIDPROXY  = 18;
    
    /** Application names */
    public static final int XPLORE               = 101;
    public static final int FELIX                = 102;
    public static final int TOPSPIN              = 103;
    public static final int VMD                  = 104;
    public static final int INSIGHT              = 105;    
    
    /** Task types */
    public static final int COMPUTATIONAL        = 1;
    public static final int EXPERIMENT           = 2;
    public static final int RADIOTELESCOPE       = 1004;
    public static final int DRYER                = 1005;
}
