/*
 * OperationsIds.java
 *
 * Created on 12 marzec 2004, 10:50
 */

package pl.psnc.vlab.remote.util;

/**
 * This class contains operations ids which are sent to the vlab modules
 * @author  <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class VlabRemoteKeys {
    
    private static StringBuffer stBuffer;
    
    
    //------------------------------------------------
    //-------   SOAP Byte Order
    /** Soap byte order: Little Endian */
    public static final int LITTLE_ENDIAN = 0;
    
    /** Soap byte order: Big Endian */
    public static final int BIG_ENDIAN = 1;
    
       
    //------------------------------------------------
    //-------   Operations status IDs
    
    /** Call remote service */
    public static final int OPERATION_STATUS_CALL = 1;
    
    /** Error in call */
    public static final int OPERATION_STATUS_ERROR = -1;
    
    /** Call OK */
    public static final int OPERATION_STATUS_OK = 2;
    
    
    
    //------------------------------------------------
    //-------   Modules IDs
    /** Portal client module */
    public static final int VL_CLIENT_ID      = 1;
    /** Communication Proxy module */
    public static final int VL_COMMPROXY_ID   = 2;
    /** DMS module */
    public static final int VL_DMSCENARIOS_ID = 3;
    /** Global scheduler */
    public static final int VL_GLOBALSCHED_ID = 4;
    /** Local scheduler */
    public static final int VL_LOCALSCHED_ID  = 5;
    /** Autehtication center */
    public static final int VL_AUTHCENTER_ID  = 6;
    /** Monitoring module */
    public static final int VL_MONITSYSTEM_ID = 7;
    /** Accounting module */
    public static final int VL_ACCTSYSTEM_ID  = 8;
    /** Gatway to the GRID system */
    public static final int VL_GRIDGATE_ID    = 9;
    /** Job submission module */
    public static final int VL_JOBSUBMEXP_ID  = 10;
    /** Postprocessing module */
    public static final int VL_POSTPROC_ID    = 11;
    /** Local monitoring */
    public static final int VL_LOCALMONIT_ID  = 12;
    /** The SZD client (Transportation module) */
    public static final int VL_TRANSMOD_ID    = 13;
    /** Scenarion submittion module */
    public static final int VL_SCEN_SUB_ID    = 14;   // Scenarion submittion module
    
    
    //------------------------------------------------
    //-------   Operation types
    /** Synchronous communication */
    public static final int VLAB_SYNC  = 0;     // synchronous communication
    /** asynchronous communication */
    public static final int VLAB_ASYNC = 1;     // asynchronous communication
    
    //------------------------------------------------
    //-------   Operations IDs
    
    
    
    //--------------------------------------------------------------------------
    //-- Monitoring Operations
    /** Operation: retrieve app session information by a given session key */
    public static final int MONITORING_GET_SESSION               = monitoringSych("008");    //retrieve app session information by a given session key
    /** Operation: checks if the app session is valid */
    public static final int MONITORING_IS_SESSION_VALID          = monitoringSych("009");    //checks if the app session is valid
    /** Operation: get user proxy */
    public static final int MONITORING_GET_USER_PROXY            = monitoringSych("026");   //get user proxy
    
    /** Operation: deletes the user app session */
    public static final int MONITORING_REMOVE_SESSION            = monitoringASych("111");   //deletes the user app session
    /** Operation: updates the app session timestamp */
    public static final int MONITORING_UPDATE_SESSION            = monitoringASych("112");   //updates the app session timestamp
    /** Operation: set new task status */
    public static final int MONITORING_SET_TASK_STATUS           = monitoringASych("101");   //set new task status
    
    
    
        
    //------
    //- Secure VNC 
    /** Operation: get the viewer configuration file */
    public static final int MONITORING_GET_VNC_CONF              = monitoringSych("006");   //get the viewer configuration file
    
    //---- SMM vs.SZD
    
    /** Operation: SZD find user elements */
    public static final int SZD_OPERATION_LOGIN_CERT             = szdSych("100");   //SZD login cert
    
    /** Operation: SZD add directory */
    public static final int SZD_ADD_DIR                          = szdSych("105");   //SZD add directory

    /** Operation: SZD get element info */
    public static final int SZD_GET_FILE_ELEM_INFO               = szdSych("107");   //SZD get element info
    
    /** Operation: SZD list directory */
    public static final int SZD_LIST_DIR                         = szdSych("108");   //SZD list directory
               
    
    /** Operation: SZD find user elements */
    public static final int SZD_FIND_USER_ELEMENTS               = szdSych("202");   //SZD find user elements
    
    //---- CommProxy vs. SMM
    
    /** Operation: scenario submission */
    public static final int SMM_SCENARIO_SUBMISSION              = smmSych("101");   //scenario submission
    
    /** Operation: NMR task ended */
    public static final int SMM_NMR_TASK_ENDED                   = smmASych("105");   //NMR task ended
    
    /** Operation: terminate scenario */
    public static final int SMM_TERMINATE_SCENARIO               = smmASych("111");   //terminate scenario
    
    //---- SMM vs. Monitoring
    
    
    /** Operation: adds NMR task */
    public static final int MONITORING_ADD_NMR_TASK              = monitoringASych("113");   //add NMR task
    
    /** Operation: adds computational task */
    public static final int MONITORING_ADD_COMP_TASK             = monitoringASych("114");   //add computational task
    
    /** Operation: adds radiotelescope task */
    public static final int MONITORING_ADD_RADIO_TASK            = monitoringASych("121");   //add radiotelescope task
    
    /** Operation: adds dryer task */
    public static final int MONITORING_ADD_DRYER_TASK            = monitoringASych("125");   //add dryer task
    
    /** Operation: adds scenario */
    public static final int MONITORING_ADD_SCENARIO              = monitoringSych("004");   //add new scenario
    
    /** Operation: adds proxy for scenario */
    public static final int MONITORING_ADD_PROXY_FOR_SCENARIO    = monitoringASych("120");   //add new proxy for scenario
    
    /** Operation: removes proxy for scenario */
    public static final int MONITORING_REM_PROXY_FOR_SCENARIO    = monitoringASych("119");   //remove proxy for scenario
    
    /** Operation: sets delete flag for scenario */
    public static final int MONITORING_SET_SCENARIO_FLAG_DELETE  = monitoringASych("122");   //set scenario flag to delete
    
    /** Operation: gets timezone by user id */
    public static final int MONITORING_GET_TIMEZONE_BY_USERID    = monitoringSych("028");   //get time zone by user id
    
    //-------
    //- SMM vs. Global Scheduler
    
    /** Operation: adds NMR task */
    public static final int GLOBALSCHED_ADD_NMR_TASK             = globalSchedASych("101");   //add NMR task
    
    /** Operation: adds computational task */
    public static final int GLOBALSCHED_ADD_COMP_TASK            = globalSchedASych("102");   //add computational task
    
    /** Operation: adds radiotelescope task */
    public static final int GLOBALSCHED_ADD_RADIO_TASK           = globalSchedASych("103");   //add radiotelescope task
    
    /** Operation: adds radiotelescope task */
    public static final int GLOBALSCHED_ADD_DRYER_TASK           = globalSchedASych("104");   //add dryer task
    
    
    /** Metohod to decode operation id to the VLAB format.
     *  The VLab operation id has the following format :
     *  XX_X_XXX    , where
     *  XX  - receiver id
     *  X   - type of the comunication (synch or asych)
     *  XXX - operation id
     * @param moduleId
     * @param operationType
     * @param operationId
     * @return operation id
     */
    protected static final int operationDecoder(int moduleId, int operationType, String operationId){
        stBuffer = new StringBuffer();
        stBuffer.append(moduleId)
        .append(operationType)
        .append(operationId);
        return new Integer( stBuffer.toString() ).intValue();
    }
    
    /**
     * Helper method for monitoring module. Decode synchronous call to the monitoring system with the
     * given operation id. The operations identifiers are defined by the static fields in the
     * VlabRemoteKeys
     * @param operationId operation identifier, which will be done by the monitoring system
     * @return full operation identifier (compilant to the VLab format)
     */
    protected static final int monitoringSych(String operationId){
        return operationDecoder(VL_MONITSYSTEM_ID, VLAB_SYNC, operationId);
    }
    
    /**
     * Helper method for monitoring module. Decode asynchronous call to the monitoring system with the
     * given operation id. The operations identifiers are defined by the static fields in the
     * VlabRemoteKeys
     * @param operationId operation identifier, which will be done by the monitoring system
     * @return full operation identifier (compilant to the VLab format)
     */
    protected static final int monitoringASych(String operationId){
        return operationDecoder(VL_MONITSYSTEM_ID, VLAB_ASYNC, operationId);
    }
    
    /**
     * Helper method for globalSched module. Decode synchronous call to the globalSched with the
     * given operation id. The operations identifiers are defined by the static fields in the
     * VlabRemoteKeys
     * @param operationId operation identifier, which will be done by the monitoring system
     * @return full operation identifier (compilant to the VLab format)
     */
    protected static final int globalSchedSych(String operationId){
        return operationDecoder(VL_GLOBALSCHED_ID, VLAB_SYNC, operationId);
    }
    
    /**
     * Helper method for smm. Decode asynchronous call to the globalSched with the
     * given operation id. The operations identifiers are defined by the static fields in the
     * VlabRemoteKeys
     * @param operationId operation identifier, which will be done by the monitoring system
     * @return full operation identifier (compilant to the VLab format)
     */
    protected static final int globalSchedASych(String operationId){
        return operationDecoder(VL_GLOBALSCHED_ID, VLAB_ASYNC, operationId);
    }
    
    
    /**
     * Helper method for szd module. Decode synchronous call to the smm with the
     * given operation id. The operations identifiers are defined by the static fields in the
     * VlabRemoteKeys
     * @param operationId operation identifier, which will be done by the monitoring system
     * @return full operation identifier (compilant to the VLab format)
     */
    protected static final int szdSych(String operationId){
        return operationDecoder(VL_TRANSMOD_ID, VLAB_SYNC, operationId);
    }
    
    /**
     * Helper method for szd. Decode asynchronous call to the smm with the
     * given operation id. The operations identifiers are defined by the static fields in the
     * VlabRemoteKeys
     * @param operationId operation identifier, which will be done by the monitoring system
     * @return full operation identifier (compilant to the VLab format)
     */
    protected static final int szdASych(String operationId){
        return operationDecoder(VL_TRANSMOD_ID, VLAB_ASYNC, operationId);
    }
    
    
        /**
     * Helper method for smm module. Decode synchronous call to the smm with the
     * given operation id. The operations identifiers are defined by the static fields in the
     * VlabRemoteKeys
     * @param operationId operation identifier, which will be done by the monitoring system
     * @return full operation identifier (compilant to the VLab format)
     */
    protected static final int smmSych(String operationId){
        return operationDecoder(VL_DMSCENARIOS_ID, VLAB_SYNC, operationId);
    }
    
    /**
     * Helper method for smm. Decode asynchronous call to the smm with the
     * given operation id. The operations identifiers are defined by the static fields in the
     * VlabRemoteKeys
     * @param operationId operation identifier, which will be done by the monitoring system
     * @return full operation identifier (compilant to the VLab format)
     */
    protected static final int smmASych(String operationId){
        return operationDecoder(VL_DMSCENARIOS_ID, VLAB_ASYNC, operationId);
    }
}
