/**
 * Created on Aug 11, 2008
 */
package pl.psnc.vlab.remote.util;

import java.io.IOException;
import java.io.InputStream;

import javax.activation.DataHandler;

import pl.psnc.vlab.util.FileTools;

/**
 * {@link RemoteHelper} class - remote helper class. Set of utility methods to
 * work with remote object, byte conversions, etc.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class RemoteHelper {

	/**
	 * Get bytes from the given data handler.
	 * 
	 * @param dataHandler data handler instance
	 * @return bytes from the given data handler
	 */
	public static byte[] getBytes(DataHandler dataHandler) {
		if (dataHandler == null) {
			return null;
		}
		try {
			InputStream inputStream = dataHandler.getInputStream();
			return FileTools.getContent(inputStream);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
}
