/*
 * PropertiesFactory.java
 *
 * Created on 24 marzec 2004, 13:45
 */

package pl.psnc.vlab.management;

/**
 * {@link PropertiesFactory} class - collects all the properties which are passed
 * to the application form the Web Server. The list of the properties is the
 * following:
 * <LI> key application session key generated by the Vlab portal </LI>
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class PropertiesFactory {

	/** Holds the name of the vlab session key */
	private final static String VLAB_SESSION_KEY = "key";

	/** Holds the name of the vlab time zone key */
	private final static String VLAB_TIME_ZONE_KEY = "timeZone";

	/** Holds the name of the vlab time zone key */
	private final static String VLAB_SUMMER_TIME_KEY = "summerTime";

	/** Holds value of the vlab default internal date format */
	private static String VLAB_INTERNAL_DATE_FORMAT = "yyyyMMdd";

	/** Holds value of the vlab default internal date format */
	private static String VLAB_INTERNAL_TIME_FORMAT = "HHmmss";

	/** Holds value of the key property */
	private static String sessionKey;

	/** Holds value of the time zone property */
	private static String timeZone;

	/** Holds value of the summer time property */
	private static Boolean isSummerTime;

	/**
	 * Gets the session key property
	 * 
	 * @return session key for the current application session
	 */
	public static String getSessionKey() {
		if (sessionKey == null) {
			sessionKey = System.getProperty(VLAB_SESSION_KEY);
		}
		return sessionKey;
	}

	/**
	 * Gets the session key property
	 * 
	 * @return session key for the current appliaction session
	 */
	public static String getTimeZone() {
		if (timeZone == null) {
			timeZone = System.getProperty(VLAB_TIME_ZONE_KEY);
		}
		return timeZone;
	}

	/**
	 * Gets the session key property
	 * 
	 * @return session key for the current appliaction session
	 */
	public static boolean isSummerTime() {
		if (isSummerTime == null) {
			isSummerTime = Boolean.valueOf(System.getProperty(VLAB_SUMMER_TIME_KEY));
		}
		return isSummerTime.booleanValue();
	}

	/**
	 * Getter for property vlabInternalDateFormat.
	 * 
	 * @return Value of property vlabInternalDateFormat.
	 */
	public static String getVlabInternalDateFormat() {
		return VLAB_INTERNAL_DATE_FORMAT;
	}

	/**
	 * Get the VLab internal time format
	 * 
	 * @return Value of property vlabInternalTimeFormat.
	 */
	public static String getVlabInternalTimeFormat() {
		return VLAB_INTERNAL_TIME_FORMAT;
	}

	/**
	 * Get the VLab internal date and time format
	 * 
	 * @return Value of property vlabInternalDateFormat.
	 */
	public static String getVlabInternalDateTimeFormat() {
		return new StringBuffer().append(VLAB_INTERNAL_DATE_FORMAT).append(
				VLAB_INTERNAL_TIME_FORMAT).toString();
	}

}
