/*
 * Configuration.java
 *
 * Created on March 8, 2005, 2:02 PM
 */

package pl.psnc.vlab.conf;

/**
 * {@link IConfiguration} interface - list of configuration keys.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface IConfiguration {

	// ------- The list of config keys

	/**
	 * Configuration key - the name of the application. This name will be used
	 * as a application folder
	 */
	public static final String KEY_APP_NAME = "module.name";

	/** Configuration key - the location of app conf directory */
	public static final String KEY_APP_CONF_DIR = "module.config.dir";

	/** Configuration key - presents the location of keystore */
	public static final String KEY_KEYSTORE = "keystore";

	/** Configuration key - the keystore password */
	public static final String KEY_KEYSTORE_PASSWD = "keystore.password";

	/** Configuration key - presents the location of truststore */
	public static final String KEY_TRUSTSTORE = "truststore";

	/** Configuration key - the keystore password */
	public static final String KEY_TRUSTSTORE_PASSWD = "truststore.password";

	// --------------------------------------------------------------------------
	// --- List of vlab modules location keys

	/** Configuration key - the Communication Proxy address */
	public static final String KEY_COMM_PROXY_LOCATION = "location.comm.proxy";

	/** Configuration key - the Authentication Module address */
	public static final String KEY_AUTH_MODULE_LOCATION = "location.authentication";

	/** Configuration key - the Monitoring Module address */
	public static final String KEY_MON_MODULE_LOCATION = "location.monitoring";

	/** Configuration key - the SMM Module address */
	public static final String KEY_SMM_MODULE_LOCATION = "location.smm";

	/** Configuration key - the Global Scheduler Module address */
	public static final String KEY_GS_MODULE_LOCATION = "location.global.scheduler";

	/** Configuration key - the SZD Module address */
	public static final String KEY_SZD_MODULE_LOCATION = "location.szd";

	/**
	 * Get application name
	 * 
	 * @return application name
	 */
	public String getAppName();

	/**
	 * Returns the absolute path to the folder, where all the configuration
	 * settings is stored.
	 * 
	 * @return path to the configuration folder
	 */
	public String getSystemConfDir();

	// -------------------------------------------------------------------------
	// --- SSL

	/**
	 * Get keystore for the application
	 * 
	 * @return keystore
	 */
	public String getKeyStore();

	/**
	 * Get keystore password
	 * 
	 * @return keystore password
	 */
	public String getKeyStorePasswd();

	/**
	 * Get truststore for the application
	 * 
	 * @return truststore for the application
	 */
	public String getTrustStore();

	/**
	 * Get truststore password
	 * 
	 * @return truststore password
	 */
	public String getTrustStorePasswd();

	// -------------------------------------------------------------------------
	// --- Vlab modules location's

	/**
	 * Get Communication Proxy Module
	 * 
	 * @return location of the commProxy module
	 */
	public String getCommProxyLocation();

	/**
	 * Get Authentication Module Location
	 * 
	 * @return location of the Authentication Module
	 */
	public String getAuthModuleLocation();

	/**
	 * Get Monitoring Module Location
	 * 
	 * @return location of the Monitoring Module
	 */
	public String getMonitoringModuleLocation();

	/**
	 * Get Global Scheduler Module Location
	 * 
	 * @return location of the Global Scheduler Module
	 */
	public String getGlobalSchedulerModuleLocation();

	/**
	 * Get SMM Module Location
	 * 
	 * @return location of the SMM Module
	 */
	public String getSMMModuleLocation();

	/**
	 * Get SZD Module Location
	 * 
	 * @return location of the SZD Module
	 */
	public String getSZDModuleLocation();

	/**
	 * The custom property getter method by the given key name
	 * 
	 * @param key the name of the property key
	 * @return the value of the given key or VlabException
	 */
	public String getProperty(String key);

}
