/*
 * ImageVertexView.java
 *
 * Created on 5 kwiecie� 2004, 14:00
 */

package pl.psnc.graph.view;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

import javax.swing.Icon;

import org.jgraph.JGraph;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

import pl.psnc.graph.model.value.GraphCellObject;
import pl.psnc.graph.renderer.RendererFactory;
import pl.psnc.graph.util.GraphKeys;
import pl.psnc.graph.vertex.ImageCell;

/**
 * {@link ImageVertexView} class - image vertex view. Overrides the default
 * JGraph vertex view to support image as cells.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ImageVertexView extends VertexView {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates new instance of ImageVertexView
	 * 
	 * @param cell cell object
	 */
	public ImageVertexView(Object cell) {
		super(cell);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.VertexView#getRenderer()
	 */
	@Override
	public CellViewRenderer getRenderer() {
		ImageCell imageCell = (ImageCell) getCell();
		GraphCellObject cellObject = (GraphCellObject) imageCell.getUserObject();
		String image = cellObject.getType().getImage();
		return RendererFactory.getRenderer(image);
	}

	// TODO check this method
	/**
	 * Update
	 * 
	 * @param graph instance of {@link JGraph}
	 * @param p point
	 */
	public void update(JGraph graph, Point2D p) {
		Icon icon = ((VertexRenderer) getRenderer()).getIcon();
		Rectangle2D bounds = new Rectangle2D.Double(p.getX(), p.getY(), icon.getIconWidth(), icon
				.getIconHeight()
				+ GraphKeys.VERTEX_LABEL_MARGIN);
		Map<Object, Object> transportMap = new HashMap<Object, Object>();
		GraphConstants.setBounds(transportMap, bounds);
		Map<Object, Map<Object, Object>> nestedMap = new HashMap<Object, Map<Object, Object>>();
		nestedMap.put(cell, transportMap);
		graph.getModel().edit(nestedMap, null, null, null);
	}

}
