/*
 * CustomCellViewFactory.java
 *
 * Created on 8 listopad 2006, 16:33
 */

package pl.psnc.graph.view;

import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;


/**
 * {@link CustomCellViewFactory} class - custom implementation of Cell View
 * Factory for creating cell views and ports.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class CustomCellViewFactory extends DefaultCellViewFactory {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.DefaultCellViewFactory#createPortView(java.lang.Object)
	 */
	@Override
	protected PortView createPortView(Object cell) {
		return new DefaultPortView(cell);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.DefaultCellViewFactory#createVertexView(java.lang.Object)
	 */
	@Override
	protected VertexView createVertexView(Object object) {
		return new ImageVertexView(object);
	}

}
