package pl.psnc.graph.vertex;

import org.jgraph.graph.DefaultGraphCell;

/**
 * {@link ImageCell} class - an extension of default graph cell. The cell is
 * displayed as an image icon.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class ImageCell extends DefaultGraphCell {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Creates a new instance of ImageVertex */
	public ImageCell() {
		this(null);
	}

	public ImageCell(Object userObject) {
		super(userObject);
	}

	/**
	 * Holds value of property mouseOver.
	 */
	private boolean mouseOver;

	/**
	 * Getter for property mouseOver.
	 * 
	 * @return Value of property mouseOver.
	 */
	public boolean isMouseOver() {
		return this.mouseOver;
	}

	/**
	 * Setter for property mouseOver.
	 * 
	 * @param mouseOver New value of property mouseOver.
	 */
	public void setMouseOver(boolean mouseOver) {
		this.mouseOver = mouseOver;
	}

}
