/*
 * GraphHelper.java
 *
 * Created on 10 sierpie� 2004, 14:13
 */

package pl.psnc.graph.util;

import java.awt.geom.Point2D;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.JGraph;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;
import org.jgraph.util.JGraphUtilities;

import pl.psnc.graph.factory.GraphCellFactory;
import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.model.value.GraphCellObject;
import pl.psnc.graph.vertex.ImageCell;

/**
 * {@link GraphHelper} class - set of utility methods for managing graph.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class GraphHelper {

	/** Logger instance */
	private static Log log = LogFactory.getLog(GraphHelper.class);

	/**
	 * Specifies whether graph is empty.
	 * 
	 * @param graph instance of {@link JGraph}
	 * @return <code>TRUE</code> when there are no nodes in the graph, false
	 *         otherwise
	 */
	public static boolean isEmpty(JGraph graph) {
		Object[] all = JGraphUtilities.getVertices(graph, null);
		int size = all != null ? all.length : 0;
		return size <= 0;
	}

	/**
	 * Get the user object from the given cell
	 * 
	 * @param cell cell object
	 * @return user object or null
	 */
	public static GraphCellObject getUserObject(Object cell) {
		if (cell == null) {
			return null;
		}
		DefaultGraphCell defaultGraphCell = (DefaultGraphCell) cell;
		Object userObject = defaultGraphCell.getUserObject();
		if (userObject == null) {
			return null;
		}
		return (GraphCellObject) userObject;
	}

	// TODO --- the following is unfiltered list of methods

	/**
	 * Checks all the edges. If they are not valid - they are removed
	 * 
	 * @param graph
	 */
	// TODO to implement
	public static void validateEdges(CustomGraph graph) {
		log.debug("<validateEdges>");
		// // get edges list
		// Object edges[] = JGraphUtilities.getEdges(graph);
		// int size = edges != null ? edges.length : 0;
		// for (int i = 0; i < size; i++) {
		// Object src = JGraphUtilities.getSourceVertex(graph, edges[i]);
		// Object dst = JGraphUtilities.getTargetVertex(graph, edges[i]);
		// try {
		// int srcId = ((GraphCellObject) ((DefaultGraphCell)
		// src).getUserObject())
		// .getResource().getTypeId();
		// int dstId = ((GraphCellObject) ((DefaultGraphCell)
		// dst).getUserObject())
		// .getResource().getTypeId();
		// if (!LinkFactory.canConnect(srcId, dstId)) {
		// // remove the edge
		// JGraphUtilities.removeCells(graph, new Object[] { edges[i] });
		// }
		// } catch (Exception e) {
		// continue;
		// }
		// }
		log.debug("</validateEdges>");
	}

	/**
	 * Test whether the given cell is vertex type
	 * 
	 * @param cell graph cell
	 * @return true/false
	 */
	public static boolean isVertex(Object cell) {
		if (cell == null) {
			return false;
		}
		boolean res = cell instanceof ImageCell ? true : false;
		return res;
	}

	/**
	 * Test whether the given cell is edge
	 * 
	 * @param cell graph cell
	 * @return true/false
	 */
	public static boolean isEdge(Object cell) {
		if (cell == null) {
			return false;
		}
		boolean res = cell instanceof DefaultEdge ? true : false;
		return res;
	}

	/**
	 * Test whether the given cell is port
	 * 
	 * @param cell graph cell
	 * @return true/false
	 */
	public static boolean isPort(Object cell) {
		return cell instanceof DefaultPort ? true : false;
	}

	/**
	 * Get number of vertices with defined resource.
	 * 
	 * @param graph instance of {@link CustomGraph}
	 * @return number of vertices with defined resource
	 */
	public static int countConcreteVerticles(CustomGraph graph) {
		Object verticles[] = JGraphUtilities.getVertices(graph, JGraphUtilities.getAll(graph));
		int size = verticles != null ? verticles.length : 0;
		int count = 0;
		for (int i = 0; i < size; i++) {
			// tbd removed if( !isGeneric((DefaultGraphCell) verticles[i])){
			count++;
			// }
		}
		return count;
	}

	/**
	 * Get port from the given port view
	 * 
	 * @param portView instance of {@link PortView}
	 * @return port instance from the given port view, or null
	 */
	public static Port getPort(PortView portView) {
		if (portView == null) {
			return null;
		}
		Object cell = portView.getCell();
		if (cell instanceof Port) {
			return (Port) cell;
		}
		return null;
	}

	/**
	 * Get source port at the given point
	 * 
	 * @param point point instance
	 * @param graph jgraph instance
	 * @return {@link PortView} at the given point
	 */
	public static PortView getSourcePortAt(Point2D point, JGraph graph) {
		graph.setJumpToDefaultPort(false);
		PortView result;
		try {
			result = graph.getPortViewAt(point.getX(), point.getY());
		} finally {
			graph.setJumpToDefaultPort(true);
		}
		return result;
	}

	/**
	 * Get target port at the given point
	 * 
	 * @param point point instance
	 * @param graph jgraph instance
	 * @return {@link PortView} at the given point
	 */
	public static PortView getTargetPortAt(Point2D point, JGraph graph) {
		return graph.getPortViewAt(point.getX(), point.getY());
	}

	/**
	 * Connect two ports
	 * 
	 * @param graph jgraph instance
	 * @param source source port, instance of {@link Port}
	 * @param target target port, instance of {@link Port}
	 */
	public static void connect(JGraph graph, PortView source, PortView target) {
		DefaultEdge edge = GraphCellFactory.createEdge();
		Port sourcePort = getPort(source);
		Port targetPort = getPort(target);

		if (graph.getModel().acceptsSource(edge, sourcePort)
				&& graph.getModel().acceptsTarget(edge, targetPort)) {
			graph.getGraphLayoutCache().insertEdge(edge, sourcePort, targetPort);
		}
	}
}
