/*
 * CustomPortRenderer.java
 *
 * Created on 8 listopad 2006, 15:48
 */

package pl.psnc.graph.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.ImageIcon;

import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.PortView;

import pl.psnc.graph.util.image.ImageKeys;
import pl.psnc.vlab.util.image.ImageFactory;

/**
 * {@link CustomPortRenderer} class - custom implementation of graph port
 * renderer.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 */
public class CustomPortRenderer extends PortRenderer {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/** Holds instance of port image */
	private static final ImageIcon portImg;

	static {
		// TODO [refactor] add this to the XML configuration
		portImg = ImageFactory.getImageBean(ImageKeys.PORT_IMAGE).getImage();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.PortRenderer#getRendererComponent(org.jgraph.JGraph,
	 *      org.jgraph.graph.CellView, boolean, boolean, boolean)
	 */
	public Component getRendererComponent(JGraph graph, CellView cellView, boolean selected,
			boolean focus, boolean preview) {

		if (cellView instanceof PortView && graph != null) {
			graphBackground = Color.red;
			this.view = (PortView) cellView;
			this.hasFocus = focus;
			this.selected = selected;
			this.preview = preview;
			this.xorEnabled = graph.isXorEnabled();
			return this;
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.graph.PortRenderer#paint(java.awt.Graphics)
	 */
	public void paint(Graphics g) {
		if (!preview) {
			portImg.paintIcon(this, g, 0, 0);
		}
		super.paint(g);
	}

	// -------------------------------------------------------------------------
	// ---- Helper methods

	/** Get size of the port image */
	public Dimension getIconSize() {
		return new Dimension(portImg.getIconWidth(), portImg.getIconHeight());
	}

}
