/**
 * Created on 6 Jan 2009
 */
package pl.psnc.graph.model.type;

/**
 * {@link IResourceTypeInfo} interface - resource type information
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public interface IResourceTypeInfo {

	/**
	 * Get resource type name
	 * 
	 * @return resource type name
	 */
	public String getName();

	/**
	 * Get resource type description
	 * 
	 * @return resource type description
	 */
	public String getDescription();

	/**
	 * Get resource type identifier
	 * 
	 * @return resource type identifier
	 */
	public int getId();

	/**
	 * Get resource type class name
	 * 
	 * @return resource type class name
	 */
	public String getClassName();

}
