/**
 * AbstractResourceType.java
 * Created on Apr 17, 2008
 */
package pl.psnc.graph.model.type;

/**
 * {@link AbstractResourceType} class - abstract, top level hierarchy class for
 * the resource types.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public abstract class AbstractResourceType implements IResourceTypeInfo, IResourceTypeDecorator {

	/** Type identifier */
	private int id;

	/** Full class name of the class representing this type */
	private String className;

	/** Type name */
	private String name;

	/** Type description */
	private String description;

	// -----------------------------------------------------------------------------------
	// ---- Setters / Getters

	/**
	 * Get value of field: id
	 * 
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * Set value of field: id
	 * 
	 * @param id the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Get value of field: className
	 * 
	 * @return the className
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * Set value of field: className
	 * 
	 * @param className the className to set
	 */
	public void setClassName(String className) {
		this.className = className;
	}

	/**
	 * Get value of field: name
	 * 
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set value of field: name
	 * 
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Get value of field: description
	 * 
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Set value of field: description
	 * 
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

}
