/*
 * CustomGraphModelListener.java
 *
 * Created on 23 lipiec 2004, 16:56
 */

package pl.psnc.graph.model.listener;

import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.graph.model.CustomGraph;
import pl.psnc.graph.util.GraphHelper;

/**
 * The model graph view listener is Observers are notified when the size, position,
 * color etc. of a cell view has changed. (Note: If the model's isAttributeStore
 * returns true, then the view is bypassed, and all attributes are stored in the model.)
 * @author  Dominik Stoklosa
 * @email  osa@man.poznan.pl
 */
public class ScenarioGraphViewListener implements Observer {
    
    /** Instance of logger*/
    private Log log = LogFactory.getLog(getClass().getName());
    
    /** Stores an instance of current graph */
    private CustomGraph graph = null;
    
    /**
     * Creates an instance of Scenario Graph Model Listener
     * @param graph
     */
    public ScenarioGraphViewListener(CustomGraph graph) {
        this.graph = graph;
    }
    
    /**
     * This method is called whenever the observed object is changed. An
     * application calls an <tt>Observable</tt> object's
     * <code>notifyObservers</code> method to have all the object's
     * observers notified of the change.
     *
     * @param   o     the observable object.
     * @param   arg   an argument passed to the <code>notifyObservers</code>
     *                 method.
     */
    public void update(java.util.Observable o, Object arg) {
        log.debug("<update>");
        //check the connections //remove not valid connections
        GraphHelper.validateEdges(graph);
        //log.debug("</update>");
    }
    
    
}
