/*
 * CustomGraphSelectionListener.java
 *
 * Created on 6 sierpie� 2004, 16:17
 */

package pl.psnc.graph.model.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;

import pl.psnc.graph.model.CustomGraph;

/**
 * {@link CustomGraphSelectionListener} class - graph selection listener
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CustomGraphSelectionListener implements GraphSelectionListener {

	/** Instance of logger */
	private Log log = LogFactory.getLog(this.getClass().getName());

	/** Stores an instance of the scenario graph */
	private CustomGraph graph;

	/** Creates a new instance of CustomGraphSelectionListener */
	public CustomGraphSelectionListener(CustomGraph graph) {
		this.graph = graph;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jgraph.event.GraphSelectionListener#valueChanged(org.jgraph.event.GraphSelectionEvent)
	 */
	public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
		log.debug("<valueChanged>");
		log.debug("</valueChanged>");
	}

	// ----------------------------------------------------------------------------------
	// ---- Setters / getters

	/**
	 * Get value of field: graph
	 * 
	 * @return the graph
	 */
	public CustomGraph getGraph() {
		return graph;
	}

	/**
	 * Set value of field: graph
	 * 
	 * @param graph the graph to set
	 */
	public void setGraph(CustomGraph graph) {
		this.graph = graph;
	}

}
