package pl.psnc.graph.model;

import java.awt.Color;

import javax.swing.ToolTipManager;

import org.jgraph.JGraph;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphLayoutCache;

import pl.psnc.graph.ui.CustomGraphUI;

/**
 * {@link CustomGraph} class - custom implementation of {@link JGraph}
 * component.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public class CustomGraph extends JGraph {

	/** Default serial uid */
	private static final long serialVersionUID = 1L;

	/**
	 * Creates a new instance of CustomGraph using model as its data source,
	 * view and marquee handler
	 * 
	 * @param model instance of graph model: {@link DefaultGraphModel}
	 * @param view instance of graph layout cache: {@link GraphLayoutCache}
	 */
	public CustomGraph(DefaultGraphModel model, GraphLayoutCache view) {
		super(model, view);
		// set tooltip manager
		ToolTipManager.sharedInstance().registerComponent(this);
		// TODO [refactor] replaced by custom graph decorator
		setPortsVisible(true);
		setGridEnabled(true);
		setGridSize(6);
		setTolerance(2);
		setHighlightColor(Color.orange);
		setHandleColor(Color.BLACK);
		setLockedHandleColor(Color.black);
		setGridColor(Color.orange);
		setAutoResizeGraph(true);
		setUI(new CustomGraphUI());
	}

}
