package pl.psnc.graph.io;

import javax.swing.filechooser.FileFilter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import pl.psnc.vlab.util.i18n.ResourceBundleManager;

/**
 * {@link FileFilterType} enum - stores a list of supported file filters. The
 * filter description is internationalized.
 * 
 * @author <a href="mailto:osa@man.poznan.pl">Dominik Stoklosa (~osa~)</a>
 * @email osa@man.poznan.pl
 * 
 */
public enum FileFilterType {

	XML("xml", "file.filter.graph.jgx");

	/** Instance of logger */
	private Log log = LogFactory.getLog("FileFilterType.class");

	/** Stores i18n properties for the filter properties */
	private static final String BUNDLE = "bundle/jgraph";

	/** Stores an instance of {@link FileFilter} */
	private FileFilter fileFilter;

	/**
	 * Creates a new instance of {@link FileFilterType}
	 * 
	 * @param extension extension of the given file filter
	 * @param descKey filter description key
	 */
	private FileFilterType(String extension, String descKey) {
		try {
			ResourceBundleManager rbm = new ResourceBundleManager(BUNDLE);
			String description = rbm.getValue(descKey);
			this.fileFilter = new GraphFileFilter(extension, description);
		} catch (Exception err) {
			log.error(err.getMessage());
		}
	}

	// ----------------------------------------------------------------------------------------
	// ---- Setters / Getters

	/**
	 * Get value of the property: fileFilter
	 * 
	 * @return the fileFilter
	 */
	public FileFilter getFileFilter() {
		return fileFilter;
	}

}
